/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator5.org.apache.curator.RetryPolicy;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.flink.shaded.curator5.org.apache.curator.retry.ExponentialBackoffRetry;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ZooKeeperUtilsTest {
    ZooKeeperUtilsTest() {
    }

    @Test
    void testZookeeperPathGeneration() {
        this.runZookeeperPathGenerationTest("/root/namespace", "root", "namespace");
        this.runZookeeperPathGenerationTest("/root/namespace", "/root/", "/namespace/");
        this.runZookeeperPathGenerationTest("/root/namespace", "//root//", "//namespace//");
        this.runZookeeperPathGenerationTest("/namespace", "////", "namespace");
        this.runZookeeperPathGenerationTest("/a/b", "//a//", "/b/");
        this.runZookeeperPathGenerationTest("/", "", "");
        this.runZookeeperPathGenerationTest("/root", "root", "////");
        this.runZookeeperPathGenerationTest("/", "");
        this.runZookeeperPathGenerationTest("/a/b/c/d", "a", "b", "c", "d");
    }

    @Test
    void testZooKeeperEnsembleConnectStringConfiguration() throws Exception {
        Configuration conf = new Configuration();
        String expected = "localhost:2891";
        this.setQuorum(conf, expected);
        String actual = ZooKeeperUtils.getZooKeeperEnsemble((Configuration)conf);
        Assertions.assertThat((String)actual).isEqualTo(expected);
        this.setQuorum(conf, " localhost:2891 ");
        actual = ZooKeeperUtils.getZooKeeperEnsemble((Configuration)conf);
        Assertions.assertThat((String)actual).isEqualTo(expected);
        this.setQuorum(conf, "localhost :2891");
        actual = ZooKeeperUtils.getZooKeeperEnsemble((Configuration)conf);
        Assertions.assertThat((String)actual).isEqualTo(expected);
        expected = "localhost:2891,localhost:2891";
        this.setQuorum(conf, "localhost:2891,localhost:2891");
        actual = ZooKeeperUtils.getZooKeeperEnsemble((Configuration)conf);
        Assertions.assertThat((String)actual).isEqualTo(expected);
        this.setQuorum(conf, "localhost:2891, localhost:2891");
        actual = ZooKeeperUtils.getZooKeeperEnsemble((Configuration)conf);
        Assertions.assertThat((String)actual).isEqualTo(expected);
        this.setQuorum(conf, "localhost :2891, localhost:2891");
        actual = ZooKeeperUtils.getZooKeeperEnsemble((Configuration)conf);
        Assertions.assertThat((String)actual).isEqualTo(expected);
        this.setQuorum(conf, " localhost:2891, localhost:2891 ");
        actual = ZooKeeperUtils.getZooKeeperEnsemble((Configuration)conf);
        Assertions.assertThat((String)actual).isEqualTo(expected);
    }

    @Test
    void testStartCuratorFrameworkFailed() throws Exception {
        TestingFatalErrorHandler handler = new TestingFatalErrorHandler();
        String errorMsg = "unexpected exception";
        CuratorFrameworkFactory.Builder curatorFrameworkBuilder = CuratorFrameworkFactory.builder().connectString("localhost:2181").retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1, 1)).zookeeperFactory((s, i, watcher, b) -> {
            throw new RuntimeException(errorMsg);
        }).namespace("flink");
        ZooKeeperUtils.startCuratorFramework((CuratorFrameworkFactory.Builder)curatorFrameworkBuilder, (FatalErrorHandler)handler);
        Assertions.assertThat((Throwable)handler.getErrorFuture().get()).hasMessage(errorMsg);
    }

    private void runZookeeperPathGenerationTest(String expectedValue, String ... paths) {
        String result = ZooKeeperUtils.generateZookeeperPath((String[])paths);
        Assertions.assertThat((String)result).isEqualTo(expectedValue);
    }

    private Configuration setQuorum(Configuration conf, String quorum) {
        conf.set(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, (Object)quorum);
        return conf;
    }
}

