/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

class LifeCycleMonitor
implements Serializable {
    private final Map<LifeCyclePhase, Integer> callTimes = new HashMap<LifeCyclePhase, Integer>();

    LifeCycleMonitor() {
    }

    public void incrementCallTime(LifeCyclePhase phase) {
        this.callTimes.compute(phase, (k, v) -> v == null ? 1 : v + 1);
    }

    public void assertCallTimes(int expectedTimes, LifeCyclePhase ... phases) {
        for (LifeCyclePhase phase : phases) {
            ((AbstractIntegerAssert)Assertions.assertThat((Integer)this.callTimes.getOrDefault((Object)phase, 0)).as("The phase %s has unexpected call times", new Object[]{phase})).isEqualTo(expectedTimes);
        }
    }

    public static enum LifeCyclePhase {
        OPEN,
        INITIALIZE_STATE,
        PROCESS_ELEMENT,
        PREPARE_SNAPSHOT_PRE_BARRIER,
        SNAPSHOT_STATE,
        NOTIFY_CHECKPOINT_COMPLETE,
        NOTIFY_CHECKPOINT_ABORT,
        FINISH,
        CLOSE;

    }
}

