/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.shuffle;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageConfiguration;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.shuffle.AllTieredShuffleMasterSnapshots;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.shuffle.ShuffleDescriptorRetriever;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.shuffle.TieredInternalShuffleMasterSnapshot;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMasterClient;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierMasterAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleDescriptor;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleHandler;
import org.apache.flink.runtime.shuffle.JobShuffleContext;
import org.apache.flink.runtime.shuffle.PartitionWithMetrics;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleMasterContext;
import org.apache.flink.runtime.shuffle.ShuffleMasterSnapshotContext;

public class TieredInternalShuffleMaster {
    private final TieredStorageMasterClient tieredStorageMasterClient;
    private final ShuffleMasterContext shuffleMasterContext;
    private final boolean useOnlyExternalTier;

    public TieredInternalShuffleMaster(ShuffleMasterContext shuffleMasterContext, ShuffleDescriptorRetriever shuffleDescriptorRetriever) {
        this.shuffleMasterContext = shuffleMasterContext;
        Configuration conf = shuffleMasterContext.getConfiguration();
        String externalTierFactoryClass = (String)conf.get(NettyShuffleEnvironmentOptions.NETWORK_HYBRID_SHUFFLE_EXTERNAL_REMOTE_TIER_FACTORY_CLASS_NAME);
        this.useOnlyExternalTier = externalTierFactoryClass != null;
        TieredStorageConfiguration tieredStorageConfiguration = TieredStorageConfiguration.fromConfiguration(conf);
        TieredStorageResourceRegistry resourceRegistry = new TieredStorageResourceRegistry();
        List<Tuple2<String, TierMasterAgent>> tierFactories = tieredStorageConfiguration.getTierFactories().stream().map(tierFactory -> Tuple2.of((Object)tierFactory.identifier(), (Object)tierFactory.createMasterAgent(resourceRegistry))).collect(Collectors.toList());
        this.tieredStorageMasterClient = new TieredStorageMasterClient(tierFactories, shuffleDescriptorRetriever);
    }

    public boolean supportsBatchSnapshot() {
        return this.useOnlyExternalTier;
    }

    public void snapshotState(CompletableFuture<AllTieredShuffleMasterSnapshots> snapshotFuture, ShuffleMasterSnapshotContext context, JobID jobId) {
        if (this.useOnlyExternalTier) {
            this.tieredStorageMasterClient.snapshotState(snapshotFuture, context, jobId);
        }
    }

    public void snapshotState(CompletableFuture<AllTieredShuffleMasterSnapshots> snapshotFuture) {
        if (this.useOnlyExternalTier) {
            this.tieredStorageMasterClient.snapshotState(snapshotFuture);
        }
    }

    public void restoreState(List<TieredInternalShuffleMasterSnapshot> snapshots, JobID jobId) {
        if (this.useOnlyExternalTier) {
            this.tieredStorageMasterClient.restoreState(snapshots, jobId);
        }
    }

    public void restoreState(TieredInternalShuffleMasterSnapshot clusterSnapshot) {
        if (this.useOnlyExternalTier) {
            this.tieredStorageMasterClient.restoreState(clusterSnapshot);
        }
    }

    public CompletableFuture<Collection<PartitionWithMetrics>> getPartitionWithMetrics(JobShuffleContext jobShuffleContext, Duration timeout, Set<ResultPartitionID> expectedPartitions) {
        if (this.useOnlyExternalTier) {
            return this.tieredStorageMasterClient.getPartitionWithMetrics(jobShuffleContext, timeout, expectedPartitions);
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    public void registerJob(JobShuffleContext context) {
        this.tieredStorageMasterClient.registerJob(context.getJobId(), this.getTierShuffleHandler(context));
    }

    public void unregisterJob(JobID jobID) {
        this.tieredStorageMasterClient.unregisterJob(jobID);
    }

    public List<TierShuffleDescriptor> addPartitionAndGetShuffleDescriptor(JobID jobID, int numSubpartitions, ResultPartitionID resultPartitionID) {
        return this.tieredStorageMasterClient.addPartitionAndGetShuffleDescriptor(jobID, numSubpartitions, resultPartitionID);
    }

    public void releasePartition(ShuffleDescriptor shuffleDescriptor) {
        this.tieredStorageMasterClient.releasePartition(shuffleDescriptor);
    }

    public void close() {
        this.tieredStorageMasterClient.close();
    }

    private TierShuffleHandler getTierShuffleHandler(final JobShuffleContext context) {
        return new TierShuffleHandler(){

            @Override
            public CompletableFuture<?> onReleasePartitions(Collection<TieredStoragePartitionId> partitionIds) {
                return context.stopTrackingAndReleasePartitions(partitionIds.stream().map(TieredStorageIdMappingUtils::convertId).collect(Collectors.toList()));
            }

            @Override
            public void onFatalError(Throwable throwable) {
                TieredInternalShuffleMaster.this.shuffleMasterContext.onFatalError(throwable);
            }
        };
    }
}

