/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.shaded.com.google.common.io.Files;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileSystemBlobStore
implements BlobStore {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemBlobStore.class);
    private final String basePath;

    FileSystemBlobStore(Configuration config) throws IOException {
        String recoveryPath = config.getString("recovery.zookeeper.storageDir", null);
        if (recoveryPath == null) {
            throw new IllegalConfigurationException(String.format("Missing configuration for file system state backend recovery path. Please specify via '%s' key.", "recovery.zookeeper.storageDir"));
        }
        this.basePath = recoveryPath + "/blob";
        FileSystem.get((URI)new Path(this.basePath).toUri()).mkdirs(new Path(this.basePath));
        LOG.info("Created blob directory {}.", (Object)this.basePath);
    }

    @Override
    public void put(File localFile, BlobKey blobKey) throws Exception {
        this.put(localFile, BlobUtils.getRecoveryPath(this.basePath, blobKey));
    }

    @Override
    public void put(File localFile, JobID jobId, String key) throws Exception {
        this.put(localFile, BlobUtils.getRecoveryPath(this.basePath, jobId, key));
    }

    private void put(File fromFile, String toBlobPath) throws Exception {
        try (FSDataOutputStream os = FileSystem.get((URI)new URI(toBlobPath)).create(new Path(toBlobPath), true);){
            LOG.debug("Copying from {} to {}.", (Object)fromFile, (Object)toBlobPath);
            Files.copy(fromFile, (OutputStream)os);
        }
    }

    @Override
    public void get(BlobKey blobKey, File localFile) throws Exception {
        this.get(BlobUtils.getRecoveryPath(this.basePath, blobKey), localFile);
    }

    @Override
    public void get(JobID jobId, String key, File localFile) throws Exception {
        this.get(BlobUtils.getRecoveryPath(this.basePath, jobId, key), localFile);
    }

    private void get(String fromBlobPath, File toFile) throws Exception {
        Preconditions.checkNotNull((Object)fromBlobPath, (String)"Blob path");
        Preconditions.checkNotNull((Object)toFile, (String)"File");
        if (!toFile.exists() && !toFile.createNewFile()) {
            throw new IllegalStateException("Failed to create target file to copy to");
        }
        URI fromUri = new URI(fromBlobPath);
        Path fromPath = new Path(fromBlobPath);
        if (FileSystem.get((URI)fromUri).exists(fromPath)) {
            try (FSDataInputStream is = FileSystem.get((URI)fromUri).open(fromPath);){
                FileOutputStream fos = new FileOutputStream(toFile);
                LOG.debug("Copying from {} to {}.", (Object)fromBlobPath, (Object)toFile);
                IOUtils.copyBytes((InputStream)is, (OutputStream)fos);
            }
        } else {
            throw new IOException(fromBlobPath + " does not exist.");
        }
    }

    @Override
    public void delete(BlobKey blobKey) {
        this.delete(BlobUtils.getRecoveryPath(this.basePath, blobKey));
    }

    @Override
    public void delete(JobID jobId, String key) {
        this.delete(BlobUtils.getRecoveryPath(this.basePath, jobId, key));
    }

    @Override
    public void deleteAll(JobID jobId) {
        this.delete(BlobUtils.getRecoveryPath(this.basePath, jobId));
    }

    private void delete(String blobPath) {
        try {
            LOG.debug("Deleting {}.", (Object)blobPath);
            FileSystem.get((URI)new URI(blobPath)).delete(new Path(blobPath), true);
        }
        catch (Exception e) {
            LOG.warn("Failed to delete blob at " + blobPath);
        }
    }

    @Override
    public void cleanUp() {
        try {
            LOG.debug("Cleaning up {}.", (Object)this.basePath);
            FileSystem.get((URI)new URI(this.basePath)).delete(new Path(this.basePath), true);
        }
        catch (Exception e) {
            LOG.error("Failed to clean up recovery directory.");
        }
    }
}

