/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.restart;

import akka.dispatch.Futures;
import java.util.ArrayDeque;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.restart.ExecutionGraphRestarter;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.util.Preconditions;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;

public class FailureRateRestartStrategy
implements RestartStrategy {
    private final Time failuresInterval;
    private final Time delayInterval;
    private final int maxFailuresPerInterval;
    private final ArrayDeque<Long> restartTimestampsDeque;

    public FailureRateRestartStrategy(int maxFailuresPerInterval, Time failuresInterval, Time delayInterval) {
        Preconditions.checkNotNull((Object)failuresInterval, (String)"Failures interval cannot be null.");
        Preconditions.checkNotNull((Object)delayInterval, (String)"Delay interval cannot be null.");
        Preconditions.checkArgument((maxFailuresPerInterval > 0 ? 1 : 0) != 0, (Object)"Maximum number of restart attempts per time unit must be greater than 0.");
        Preconditions.checkArgument((failuresInterval.getSize() > 0L ? 1 : 0) != 0, (Object)"Failures interval must be greater than 0 ms.");
        Preconditions.checkArgument((delayInterval.getSize() >= 0L ? 1 : 0) != 0, (Object)"Delay interval must be at least 0 ms.");
        this.failuresInterval = failuresInterval;
        this.delayInterval = delayInterval;
        this.maxFailuresPerInterval = maxFailuresPerInterval;
        this.restartTimestampsDeque = new ArrayDeque(maxFailuresPerInterval);
    }

    @Override
    public boolean canRestart() {
        if (this.isRestartTimestampsQueueFull()) {
            Long now = System.currentTimeMillis();
            Long earliestFailure = this.restartTimestampsDeque.peek();
            return now - earliestFailure > this.failuresInterval.toMilliseconds();
        }
        return true;
    }

    @Override
    public void restart(ExecutionGraph executionGraph) {
        if (this.isRestartTimestampsQueueFull()) {
            this.restartTimestampsDeque.remove();
        }
        this.restartTimestampsDeque.add(System.currentTimeMillis());
        Futures.future(ExecutionGraphRestarter.restartWithDelay(executionGraph, this.delayInterval.toMilliseconds()), (ExecutionContext)executionGraph.getExecutionContext());
    }

    private boolean isRestartTimestampsQueueFull() {
        return this.restartTimestampsDeque.size() == this.maxFailuresPerInterval;
    }

    public static FailureRateRestartStrategyFactory createFactory(Configuration configuration) throws Exception {
        int maxFailuresPerInterval = configuration.getInteger("restart-strategy.failure-rate.max-failures-per-interval", 1);
        String failuresIntervalString = configuration.getString("restart-strategy.failure-rate.failure-rate-interval", Duration.apply((long)1L, (TimeUnit)TimeUnit.MINUTES).toString());
        String timeoutString = configuration.getString("akka.watch.heartbeat.interval", ConfigConstants.DEFAULT_AKKA_ASK_TIMEOUT);
        String delayString = configuration.getString("restart-strategy.failure-rate.delay", timeoutString);
        Duration failuresInterval = Duration.apply((String)failuresIntervalString);
        Duration delay = Duration.apply((String)delayString);
        return new FailureRateRestartStrategyFactory(maxFailuresPerInterval, Time.milliseconds((long)failuresInterval.toMillis()), Time.milliseconds((long)delay.toMillis()));
    }

    public static class FailureRateRestartStrategyFactory
    extends RestartStrategyFactory {
        private static final long serialVersionUID = -373724639430960480L;
        private final int maxFailuresPerInterval;
        private final Time failuresInterval;
        private final Time delayInterval;

        public FailureRateRestartStrategyFactory(int maxFailuresPerInterval, Time failuresInterval, Time delayInterval) {
            this.maxFailuresPerInterval = maxFailuresPerInterval;
            this.failuresInterval = (Time)Preconditions.checkNotNull((Object)failuresInterval);
            this.delayInterval = (Time)Preconditions.checkNotNull((Object)delayInterval);
        }

        @Override
        public RestartStrategy createRestartStrategy() {
            return new FailureRateRestartStrategy(this.maxFailuresPerInterval, this.failuresInterval, this.delayInterval);
        }
    }
}

