/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output.operators;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Collector;

@Internal
public class GroupReduceOperator<IN, OUT>
extends AbstractUdfStreamOperator<OUT, GroupReduceFunction<IN, OUT>>
implements OneInputStreamOperator<IN, OUT> {
    private transient List<IN> buffer;

    public GroupReduceOperator(GroupReduceFunction<IN, OUT> userFunction) {
        super(userFunction);
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    public void open() throws Exception {
        super.open();
        this.buffer = new ArrayList<IN>();
    }

    public void processElement(StreamRecord<IN> element) throws Exception {
        this.buffer.add(element.getValue());
    }

    public void finish() throws Exception {
        ((GroupReduceFunction)this.getUserFunction()).reduce(this.buffer, (Collector)new TimestampedCollector(this.output));
    }
}

