/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.runtime.metadata;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.state.api.runtime.StateBootstrapTransformationWithID;
import org.apache.flink.util.Preconditions;

@Internal
class OperatorStateSpecV2 {
    private final OperatorID id;
    @Nullable
    private final OperatorState existingState;
    @Nullable
    private final StateBootstrapTransformationWithID<?> newOperatorStateTransformation;

    static OperatorStateSpecV2 existing(OperatorState existingState) {
        return new OperatorStateSpecV2((OperatorState)Preconditions.checkNotNull((Object)existingState));
    }

    static OperatorStateSpecV2 newWithTransformation(StateBootstrapTransformationWithID<?> transformation) {
        return new OperatorStateSpecV2((StateBootstrapTransformationWithID)Preconditions.checkNotNull(transformation));
    }

    private OperatorStateSpecV2(OperatorState existingState) {
        this.id = existingState.getOperatorID();
        this.existingState = existingState;
        this.newOperatorStateTransformation = null;
    }

    private OperatorStateSpecV2(StateBootstrapTransformationWithID<?> transformation) {
        this.id = transformation.getOperatorID();
        this.newOperatorStateTransformation = transformation;
        this.existingState = null;
    }

    boolean isExistingState() {
        return this.existingState != null;
    }

    boolean isNewStateTransformation() {
        return !this.isExistingState();
    }

    OperatorState asExistingState() {
        Preconditions.checkState((boolean)this.isExistingState(), (String)"OperatorState %s is not an existing state.", (Object[])new Object[]{this.id});
        return this.existingState;
    }

    <T> StateBootstrapTransformationWithID<T> asNewStateTransformation() {
        Preconditions.checkState((boolean)this.isNewStateTransformation(), (String)"OperatorState %s is not a new state defined with BootstrapTransformation", (Object[])new Object[]{this.id});
        return this.newOperatorStateTransformation;
    }
}

