/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointMetadata;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

@Internal
public class MergeOperatorStates
implements GroupReduceFunction<OperatorState, CheckpointMetadata> {
    private static final long serialVersionUID = 1L;
    private final long checkpointId;
    private final Collection<MasterState> masterStates;

    public MergeOperatorStates(long checkpointId, Collection<MasterState> masterStates) {
        Preconditions.checkNotNull(masterStates, (String)"Master state metadata must not be null");
        this.checkpointId = checkpointId;
        this.masterStates = masterStates;
    }

    public void reduce(Iterable<OperatorState> values, Collector<CheckpointMetadata> out) {
        CheckpointMetadata metadata = new CheckpointMetadata(this.checkpointId, (Collection)StreamSupport.stream(values.spliterator(), false).collect(Collectors.toList()), this.masterStates);
        out.collect((Object)metadata);
    }
}

