/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.table;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.naming.ConfigurationException;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.StateBackendOptions;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StateBackendLoader;
import org.apache.flink.state.api.OperatorIdentifier;
import org.apache.flink.state.api.SavepointReader;
import org.apache.flink.state.table.KeyedStateReader;
import org.apache.flink.state.table.StateValueColumnConfiguration;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.connector.ProviderContext;
import org.apache.flink.table.connector.source.DataStreamScanProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.StringUtils;

public class SavepointDataStreamScanProvider
implements DataStreamScanProvider {
    @Nullable
    private final String stateBackendType;
    private final String statePath;
    private final OperatorIdentifier operatorIdentifier;
    private final TypeInformation keyTypeInfo;
    private final Tuple2<Integer, List<StateValueColumnConfiguration>> keyValueProjections;
    private final RowType rowType;

    public SavepointDataStreamScanProvider(@Nullable String stateBackendType, String statePath, OperatorIdentifier operatorIdentifier, TypeInformation keyTypeInfo, Tuple2<Integer, List<StateValueColumnConfiguration>> keyValueProjections, RowType rowType) {
        this.stateBackendType = stateBackendType;
        this.statePath = statePath;
        this.operatorIdentifier = operatorIdentifier;
        this.keyTypeInfo = keyTypeInfo;
        this.keyValueProjections = keyValueProjections;
        this.rowType = rowType;
    }

    public boolean isBounded() {
        return true;
    }

    public DataStream<RowData> produceDataStream(ProviderContext providerContext, StreamExecutionEnvironment execEnv) {
        try {
            Configuration configuration = Configuration.fromMap((Map)execEnv.getConfiguration().toMap());
            if (!StringUtils.isNullOrWhitespaceOnly((String)this.stateBackendType)) {
                configuration.set(StateBackendOptions.STATE_BACKEND, (Object)this.stateBackendType);
            }
            StateBackend stateBackend = StateBackendLoader.loadStateBackendFromConfig((ReadableConfig)configuration, (ClassLoader)this.getClass().getClassLoader(), null);
            SavepointReader savepointReader = SavepointReader.read(execEnv, this.statePath, stateBackend);
            block7: for (StateValueColumnConfiguration columnConfig : (List)this.keyValueProjections.f1) {
                TypeInformation valueTypeInfo = columnConfig.getValueTypeInfo();
                switch (columnConfig.getStateType()) {
                    case VALUE: {
                        columnConfig.setStateDescriptor((StateDescriptor)new ValueStateDescriptor(columnConfig.getStateName(), valueTypeInfo));
                        continue block7;
                    }
                    case LIST: {
                        columnConfig.setStateDescriptor((StateDescriptor)new ListStateDescriptor(columnConfig.getStateName(), valueTypeInfo));
                        continue block7;
                    }
                    case MAP: {
                        TypeInformation mapKeyTypeInfo = columnConfig.getMapKeyTypeInfo();
                        if (mapKeyTypeInfo == null) {
                            throw new ConfigurationException("Map key type information is required for map state");
                        }
                        columnConfig.setStateDescriptor((StateDescriptor)new MapStateDescriptor(columnConfig.getStateName(), mapKeyTypeInfo, valueTypeInfo));
                        continue block7;
                    }
                }
                throw new UnsupportedOperationException("Unsupported state type: " + columnConfig.getStateType());
            }
            InternalTypeInfo outTypeInfo = InternalTypeInfo.of((RowType)this.rowType);
            return savepointReader.readKeyedState(this.operatorIdentifier, new KeyedStateReader(this.rowType, this.keyValueProjections), this.keyTypeInfo, outTypeInfo);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

