/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.table;

import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointMetadata;
import org.apache.flink.state.api.runtime.SavepointLoader;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.types.Row;

@Internal
@FunctionHint(output=@DataTypeHint(value="ROW<checkpoint-id BIGINT NOT NULL, operator-name STRING, operator-uid STRING, operator-uid-hash STRING NOT NULL, operator-parallelism INT NOT NULL, operator-max-parallelism INT NOT NULL, operator-subtask-state-count INT NOT NULL, operator-coordinator-state-size-in-bytes BIGINT NOT NULL, operator-total-size-in-bytes BIGINT NOT NULL>"))
public class SavepointMetadataTableFunction
extends TableFunction<Row> {
    public SavepointMetadataTableFunction(SpecializedFunction.SpecializedContext context) {
    }

    public void eval(String savepointPath) {
        try {
            CheckpointMetadata checkpointMetadata = SavepointLoader.loadSavepointMetadata(savepointPath);
            for (OperatorState operatorState : checkpointMetadata.getOperatorStates()) {
                Row row = Row.withNames();
                row.setField("checkpoint-id", (Object)checkpointMetadata.getCheckpointId());
                row.setField("operator-name", operatorState.getOperatorName().orElse(null));
                row.setField("operator-uid", operatorState.getOperatorUid().orElse(null));
                row.setField("operator-uid-hash", (Object)operatorState.getOperatorID().toHexString());
                row.setField("operator-parallelism", (Object)operatorState.getParallelism());
                row.setField("operator-max-parallelism", (Object)operatorState.getMaxParallelism());
                row.setField("operator-subtask-state-count", (Object)operatorState.getStates().size());
                row.setField("operator-coordinator-state-size-in-bytes", (Object)(operatorState.getCoordinatorState() != null ? operatorState.getCoordinatorState().getStateSize() : 0L));
                row.setField("operator-total-size-in-bytes", (Object)operatorState.getCheckpointedSize());
                this.collect(row);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

