/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.api.common.state.State;
import org.apache.flink.runtime.state.InternalKeyContext;
import org.apache.flink.runtime.state.internal.InternalAggregatingState;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.state.changelog.AbstractChangelogState;
import org.apache.flink.state.changelog.KvStateChangeLogger;
import org.apache.flink.state.changelog.restore.ChangelogApplierFactory;
import org.apache.flink.state.changelog.restore.StateChangeApplier;
import org.apache.flink.util.ExceptionUtils;

class ChangelogAggregatingState<K, N, IN, ACC, OUT>
extends AbstractChangelogState<K, N, ACC, InternalAggregatingState<K, N, IN, ACC, OUT>>
implements InternalAggregatingState<K, N, IN, ACC, OUT> {
    private final InternalKeyContext<K> keyContext;

    ChangelogAggregatingState(InternalAggregatingState<K, N, IN, ACC, OUT> delegatedState, KvStateChangeLogger<ACC, N> changeLogger, InternalKeyContext<K> keyContext) {
        super(delegatedState, changeLogger);
        this.keyContext = keyContext;
    }

    public void mergeNamespaces(N target, Collection<N> sources) throws Exception {
        ((InternalAggregatingState)this.delegatedState).mergeNamespaces(target, sources);
        this.changeLogger.namespacesMerged(target, sources);
    }

    public ACC getInternal() throws Exception {
        return (ACC)((InternalAggregatingState)this.delegatedState).getInternal();
    }

    public void updateInternal(ACC valueToStore) throws Exception {
        ((InternalAggregatingState)this.delegatedState).updateInternal(valueToStore);
        this.changeLogger.valueUpdatedInternal(valueToStore, this.getCurrentNamespace());
    }

    public OUT get() throws Exception {
        return (OUT)((InternalAggregatingState)this.delegatedState).get();
    }

    public void add(IN value) throws Exception {
        ((InternalAggregatingState)this.delegatedState).add(value);
        this.changeLogger.valueUpdatedInternal(((InternalAggregatingState)this.delegatedState).getInternal(), this.getCurrentNamespace());
    }

    public void clear() {
        ((InternalAggregatingState)this.delegatedState).clear();
        try {
            this.changeLogger.valueCleared(this.getCurrentNamespace());
        }
        catch (IOException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    static <T, K, N, SV, S extends State, IS extends S> IS create(InternalKvState<K, N, SV> aggregatingState, KvStateChangeLogger<SV, N> changeLogger, InternalKeyContext<K> keyContext) {
        return (IS)new ChangelogAggregatingState((InternalAggregatingState)aggregatingState, changeLogger, keyContext);
    }

    @Override
    public StateChangeApplier getChangeApplier(ChangelogApplierFactory factory) {
        return factory.forAggregating((InternalAggregatingState)this.delegatedState, this.keyContext);
    }
}

