/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import javax.annotation.Nullable;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.contrib.streaming.state.MemoryShareScope;
import org.apache.flink.contrib.streaming.state.RocksDBMemoryConfiguration;
import org.apache.flink.contrib.streaming.state.RocksDBMemoryControllerUtils;
import org.apache.flink.contrib.streaming.state.RocksDBOptions;
import org.apache.flink.contrib.streaming.state.RocksDBSharedResources;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.memory.OpaqueMemoryResource;
import org.apache.flink.runtime.memory.SharedResources;
import org.apache.flink.util.function.LongFunctionWithException;
import org.apache.flink.util.function.ThrowingRunnable;
import org.slf4j.Logger;

enum RocksDBSharedResourcesFactory {
    SLOT_SHARED_MANAGED(false, MemoryShareScope.SLOT){

        @Override
        protected OpaqueMemoryResource<RocksDBSharedResources> createInternal(RocksDBMemoryConfiguration jobMemoryConfig, String resourceId, Environment env, double memoryFraction, LongFunctionWithException<RocksDBSharedResources, Exception> allocator) throws Exception {
            return env.getMemoryManager().getSharedMemoryResourceForManagedMemory(resourceId, allocator, memoryFraction);
        }
    }
    ,
    SLOT_SHARED_UNMANAGED(false, MemoryShareScope.SLOT){

        @Override
        protected OpaqueMemoryResource<RocksDBSharedResources> createInternal(RocksDBMemoryConfiguration jobMemoryConfig, String resourceId, Environment env, double memoryFraction, LongFunctionWithException<RocksDBSharedResources, Exception> allocator) throws Exception {
            return env.getMemoryManager().getExternalSharedMemoryResource(resourceId, allocator, jobMemoryConfig.getFixedMemoryPerSlot().getBytes());
        }
    }
    ,
    TM_SHARED_UNMANAGED(false, MemoryShareScope.TM){

        @Override
        protected OpaqueMemoryResource<RocksDBSharedResources> createInternal(RocksDBMemoryConfiguration jobMemoryConfig, String resourceId, Environment env, double memoryFraction, LongFunctionWithException<RocksDBSharedResources, Exception> allocator) throws Exception {
            SharedResources sharedResources = env.getSharedResources();
            Object leaseHolder = new Object();
            SharedResources.ResourceAndSize resource = sharedResources.getOrAllocateSharedResource(resourceId, leaseHolder, allocator, RocksDBSharedResourcesFactory.getTmSharedMemorySize(env));
            ThrowingRunnable disposer = () -> sharedResources.release(resourceId, leaseHolder, unused -> {});
            return new OpaqueMemoryResource((Object)((RocksDBSharedResources)resource.resourceHandle()), resource.size(), disposer);
        }
    };

    private final boolean managed;
    private final MemoryShareScope shareScope;
    private static final String MANAGED_MEMORY_RESOURCE_ID = "state-rocks-managed-memory";
    private static final String UNMANAGED_MEMORY_RESOURCE_ID = "state-rocks-fixed-slot-memory";

    private RocksDBSharedResourcesFactory(boolean managed, MemoryShareScope shareScope) {
        this.managed = managed;
        this.shareScope = shareScope;
    }

    @Nullable
    public static RocksDBSharedResourcesFactory from(RocksDBMemoryConfiguration jobMemoryConfig, Environment env) {
        if (jobMemoryConfig.isUsingFixedMemoryPerSlot()) {
            return SLOT_SHARED_UNMANAGED;
        }
        if (jobMemoryConfig.isUsingManagedMemory()) {
            return SLOT_SHARED_MANAGED;
        }
        if (RocksDBSharedResourcesFactory.getTmSharedMemorySize(env) > 0L) {
            return TM_SHARED_UNMANAGED;
        }
        return null;
    }

    public final OpaqueMemoryResource<RocksDBSharedResources> create(RocksDBMemoryConfiguration jobMemoryConfig, Environment env, double memoryFraction, Logger logger, RocksDBMemoryControllerUtils.RocksDBMemoryFactory rocksDBMemoryFactory) throws Exception {
        logger.info("Getting shared memory for RocksDB: shareScope={}, managed={}", (Object)this.shareScope, (Object)this.managed);
        return this.createInternal(jobMemoryConfig, this.managed ? MANAGED_MEMORY_RESOURCE_ID : UNMANAGED_MEMORY_RESOURCE_ID, env, memoryFraction, RocksDBSharedResourcesFactory.createAllocator(this.shareScope.getConfiguration(jobMemoryConfig, env), rocksDBMemoryFactory));
    }

    protected abstract OpaqueMemoryResource<RocksDBSharedResources> createInternal(RocksDBMemoryConfiguration var1, String var2, Environment var3, double var4, LongFunctionWithException<RocksDBSharedResources, Exception> var6) throws Exception;

    private static long getTmSharedMemorySize(Environment env) {
        return env.getTaskManagerInfo().getConfiguration().getOptional(RocksDBOptions.FIX_PER_TM_MEMORY_SIZE).orElse(MemorySize.ZERO).getBytes();
    }

    private static LongFunctionWithException<RocksDBSharedResources, Exception> createAllocator(RocksDBMemoryConfiguration config, RocksDBMemoryControllerUtils.RocksDBMemoryFactory rocksDBMemoryFactory) {
        return size -> RocksDBMemoryControllerUtils.allocateRocksDBSharedResources(size, config.getWriteBufferRatio(), config.getHighPriorityPoolRatio(), config.isUsingPartitionedIndexFilters(), rocksDBMemoryFactory);
    }
}

