/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.api.connector.sink.GlobalCommitter;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.api.connector.sink.SinkWriter;
import org.apache.flink.api.connector.sink2.StatefulSink;
import org.apache.flink.api.connector.sink2.TwoPhaseCommittingSink;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.connector.sink2.WithPostCommitTopology;
import org.apache.flink.streaming.api.transformations.SinkV1Adapter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class SinkV1AdapterTest {
    SinkV1AdapterTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"provideSinkCombinations"})
    void testSinkCombinations(Sink<?, ?, ?, ?> sinkV1, Collection<Class<org.apache.flink.api.connector.sink2.Sink<?>>> sinkInterfaces) {
        org.apache.flink.api.connector.sink2.Sink converted = SinkV1Adapter.wrap(sinkV1);
        for (Class<org.apache.flink.api.connector.sink2.Sink<?>> sinkInterface : sinkInterfaces) {
            Assertions.assertThat((Object)converted).isInstanceOf(sinkInterface);
        }
    }

    private static List<Arguments> provideSinkCombinations() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{new DefaultSinkV1(), Collections.singletonList(org.apache.flink.api.connector.sink2.Sink.class)}), Arguments.of((Object[])new Object[]{new StateFulSinkV1(), Arrays.asList(org.apache.flink.api.connector.sink2.Sink.class, StatefulSink.class)}), Arguments.of((Object[])new Object[]{new CommittingSinkV1(), Arrays.asList(org.apache.flink.api.connector.sink2.Sink.class, TwoPhaseCommittingSink.class)}), Arguments.of((Object[])new Object[]{new StatefulCommittingSinkV1(), Arrays.asList(org.apache.flink.api.connector.sink2.Sink.class, StatefulSink.class, TwoPhaseCommittingSink.class)}), Arguments.of((Object[])new Object[]{new GlobalCommittingSinkV1(), Arrays.asList(org.apache.flink.api.connector.sink2.Sink.class, TwoPhaseCommittingSink.class, WithPostCommitTopology.class)}), Arguments.of((Object[])new Object[]{new StatefulGlobalCommittingSinkV1(), Arrays.asList(org.apache.flink.api.connector.sink2.Sink.class, StatefulSink.class, TwoPhaseCommittingSink.class, WithPostCommitTopology.class)}));
    }

    private static class NoOpSerializer
    implements SimpleVersionedSerializer<Integer> {
        private NoOpSerializer() {
        }

        public int getVersion() {
            return 0;
        }

        public byte[] serialize(Integer obj) throws IOException {
            return new byte[0];
        }

        public Integer deserialize(int version, byte[] serialized) throws IOException {
            return null;
        }
    }

    private static class StatefulGlobalCommittingSinkV1
    extends StatefulCommittingSinkV1 {
        private StatefulGlobalCommittingSinkV1() {
        }

        @Override
        public Optional<SimpleVersionedSerializer<Integer>> getGlobalCommittableSerializer() {
            return Optional.of(new NoOpSerializer());
        }
    }

    private static class GlobalCommittingSinkV1
    extends CommittingSinkV1 {
        private GlobalCommittingSinkV1() {
        }

        @Override
        public Optional<SimpleVersionedSerializer<Integer>> getGlobalCommittableSerializer() {
            return Optional.of(new NoOpSerializer());
        }
    }

    private static class StatefulCommittingSinkV1
    extends CommittingSinkV1 {
        private StatefulCommittingSinkV1() {
        }

        @Override
        public Optional<SimpleVersionedSerializer<Integer>> getWriterStateSerializer() {
            return Optional.of(new NoOpSerializer());
        }
    }

    private static class CommittingSinkV1
    extends DefaultSinkV1 {
        private CommittingSinkV1() {
        }

        @Override
        public Optional<SimpleVersionedSerializer<Integer>> getCommittableSerializer() {
            return Optional.of(new NoOpSerializer());
        }

        @Override
        public Optional<Committer<Integer>> createCommitter() throws IOException {
            return Optional.of(new Committer<Integer>(){

                public List<Integer> commit(List<Integer> committables) {
                    throw new UnsupportedOperationException();
                }

                public void close() {
                    throw new UnsupportedOperationException();
                }
            });
        }
    }

    private static class StateFulSinkV1
    extends DefaultSinkV1 {
        private StateFulSinkV1() {
        }

        @Override
        public Optional<SimpleVersionedSerializer<Integer>> getWriterStateSerializer() {
            return Optional.of(new NoOpSerializer());
        }
    }

    private static class DefaultSinkV1
    implements Sink<Integer, Integer, Integer, Integer> {
        private DefaultSinkV1() {
        }

        public SinkWriter<Integer, Integer, Integer> createWriter(Sink.InitContext context, List<Integer> states) throws IOException {
            return null;
        }

        public Optional<SimpleVersionedSerializer<Integer>> getWriterStateSerializer() {
            return Optional.empty();
        }

        public Optional<Committer<Integer>> createCommitter() throws IOException {
            return Optional.empty();
        }

        public Optional<GlobalCommitter<Integer, Integer>> createGlobalCommitter() throws IOException {
            return Optional.empty();
        }

        public Optional<SimpleVersionedSerializer<Integer>> getCommittableSerializer() {
            return Optional.empty();
        }

        public Optional<SimpleVersionedSerializer<Integer>> getGlobalCommittableSerializer() {
            return Optional.empty();
        }
    }
}

