/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.lang.reflect.Method;
import java.util.Collections;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.windowing.triggers.PurgingTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.TriggerTestHarness;
import org.apache.flink.streaming.runtime.operators.windowing.WindowOperatorContractTest;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class PurgingTriggerTest {
    @Test
    public void testAllMethodsImplemented() throws NoSuchMethodException {
        for (Method triggerMethod : Trigger.class.getDeclaredMethods()) {
            PurgingTrigger.class.getDeclaredMethod(triggerMethod.getName(), triggerMethod.getParameterTypes());
        }
    }

    @Test
    public void testForwarding() throws Exception {
        Trigger mockTrigger = (Trigger)Mockito.mock(Trigger.class);
        TriggerTestHarness testHarness = new TriggerTestHarness(PurgingTrigger.of((Trigger)mockTrigger), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Mockito.when((Object)mockTrigger.onElement(Matchers.anyObject(), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.CONTINUE);
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Mockito.when((Object)mockTrigger.onElement(Matchers.anyObject(), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.FIRE);
        Assert.assertEquals((Object)TriggerResult.FIRE_AND_PURGE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Mockito.when((Object)mockTrigger.onElement(Matchers.anyObject(), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.FIRE_AND_PURGE);
        Assert.assertEquals((Object)TriggerResult.FIRE_AND_PURGE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        Mockito.when((Object)mockTrigger.onElement(Matchers.anyObject(), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.PURGE);
        Assert.assertEquals((Object)TriggerResult.PURGE, (Object)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L)));
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                context.registerEventTimeTimer(1L);
                context.registerEventTimeTimer(2L);
                context.registerEventTimeTimer(3L);
                context.registerEventTimeTimer(4L);
                return TriggerResult.CONTINUE;
            }
        }).when((Object)mockTrigger)).onElement(Matchers.anyObject(), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L));
        Assert.assertEquals((long)4L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 2L)));
        Mockito.when((Object)mockTrigger.onEventTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.CONTINUE);
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.advanceWatermark(1L, new TimeWindow(0L, 2L)));
        Mockito.when((Object)mockTrigger.onEventTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.FIRE);
        Assert.assertEquals((Object)TriggerResult.FIRE_AND_PURGE, (Object)testHarness.advanceWatermark(2L, new TimeWindow(0L, 2L)));
        Mockito.when((Object)mockTrigger.onEventTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.FIRE_AND_PURGE);
        Assert.assertEquals((Object)TriggerResult.FIRE_AND_PURGE, (Object)testHarness.advanceWatermark(3L, new TimeWindow(0L, 2L)));
        Mockito.when((Object)mockTrigger.onEventTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.PURGE);
        Assert.assertEquals((Object)TriggerResult.PURGE, (Object)testHarness.advanceWatermark(4L, new TimeWindow(0L, 2L)));
        ((Trigger)Mockito.doAnswer((Answer)new Answer<TriggerResult>(){

            public TriggerResult answer(InvocationOnMock invocation) throws Exception {
                Trigger.TriggerContext context = (Trigger.TriggerContext)invocation.getArguments()[3];
                context.registerProcessingTimeTimer(1L);
                context.registerProcessingTimeTimer(2L);
                context.registerProcessingTimeTimer(3L);
                context.registerProcessingTimeTimer(4L);
                return TriggerResult.CONTINUE;
            }
        }).when((Object)mockTrigger)).onElement(Matchers.anyObject(), Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext());
        testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L));
        Assert.assertEquals((long)4L, (long)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L)));
        Assert.assertEquals((long)0L, (long)testHarness.numEventTimeTimers(new TimeWindow(0L, 2L)));
        Mockito.when((Object)mockTrigger.onProcessingTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.CONTINUE);
        Assert.assertEquals((Object)TriggerResult.CONTINUE, (Object)testHarness.advanceProcessingTime(1L, new TimeWindow(0L, 2L)));
        Mockito.when((Object)mockTrigger.onProcessingTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.FIRE);
        Assert.assertEquals((Object)TriggerResult.FIRE_AND_PURGE, (Object)testHarness.advanceProcessingTime(2L, new TimeWindow(0L, 2L)));
        Mockito.when((Object)mockTrigger.onProcessingTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.FIRE_AND_PURGE);
        Assert.assertEquals((Object)TriggerResult.FIRE_AND_PURGE, (Object)testHarness.advanceProcessingTime(3L, new TimeWindow(0L, 2L)));
        Mockito.when((Object)mockTrigger.onProcessingTime(Matchers.anyLong(), (Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyTriggerContext())).thenReturn((Object)TriggerResult.PURGE);
        Assert.assertEquals((Object)TriggerResult.PURGE, (Object)testHarness.advanceProcessingTime(4L, new TimeWindow(0L, 2L)));
        testHarness.mergeWindows(new TimeWindow(0L, 2L), Collections.singletonList(new TimeWindow(0L, 1L)));
        ((Trigger)Mockito.verify((Object)mockTrigger, (VerificationMode)Mockito.times((int)1))).onMerge((Window)WindowOperatorContractTest.anyTimeWindow(), WindowOperatorContractTest.anyOnMergeContext());
        testHarness.clearTriggerState(new TimeWindow(0L, 2L));
        ((Trigger)Mockito.verify((Object)mockTrigger, (VerificationMode)Mockito.times((int)1))).clear((Window)Mockito.eq((Object)new TimeWindow(0L, 2L)), WindowOperatorContractTest.anyTriggerContext());
    }
}

