/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.io.SimpleVersionedSerializerTypeSerializerProxy;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.CommitterOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.SinkWriterOperatorFactory;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class SinkTransformationTranslatorITCaseBase<SinkT>
extends TestLogger {
    @Parameterized.Parameter
    public RuntimeExecutionMode runtimeExecutionMode;
    static final String NAME = "FileSink";
    static final String SLOT_SHARE_GROUP = "FileGroup";
    static final String UID = "FileUid";
    static final int PARALLELISM = 2;

    @Parameterized.Parameters(name="Execution Mode: {0}")
    public static Collection<Object> data() {
        return Arrays.asList(RuntimeExecutionMode.STREAMING, RuntimeExecutionMode.BATCH);
    }

    abstract SinkT simpleSink();

    abstract SinkT sinkWithCommitter();

    abstract DataStreamSink<Integer> sinkTo(DataStream<Integer> var1, SinkT var2);

    @Test
    public void generateWriterTopology() {
        StreamGraph streamGraph = this.buildGraph(this.simpleSink(), this.runtimeExecutionMode);
        StreamNode sourceNode = this.findNodeName(streamGraph, node -> node.contains("Source"));
        StreamNode writerNode = this.findWriter(streamGraph);
        MatcherAssert.assertThat((Object)streamGraph.getStreamNodes().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.validateTopology(sourceNode, IntSerializer.class, writerNode, SinkWriterOperatorFactory.class, 2, -1);
    }

    @Test
    public void generateWriterCommitterTopology() {
        StreamGraph streamGraph = this.buildGraph(this.sinkWithCommitter(), this.runtimeExecutionMode);
        StreamNode sourceNode = this.findNodeName(streamGraph, node -> node.contains("Source"));
        StreamNode writerNode = this.findWriter(streamGraph);
        this.validateTopology(sourceNode, IntSerializer.class, writerNode, SinkWriterOperatorFactory.class, 2, -1);
        StreamNode committerNode = this.findNodeName(streamGraph, name -> name.contains("Committer"));
        MatcherAssert.assertThat((Object)streamGraph.getStreamNodes().size(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.validateTopology(writerNode, SimpleVersionedSerializerTypeSerializerProxy.class, committerNode, CommitterOperatorFactory.class, 2, -1);
    }

    StreamNode findWriter(StreamGraph streamGraph) {
        return this.findNodeName(streamGraph, name -> name.contains("Writer") && !name.contains("Committer"));
    }

    StreamNode findCommitter(StreamGraph streamGraph) {
        return this.findNodeName(streamGraph, name -> name.contains("Committer") && !name.contains("Global Committer"));
    }

    StreamNode findGlobalCommitter(StreamGraph streamGraph) {
        return this.findNodeName(streamGraph, name -> name.contains("Global Committer"));
    }

    @Test(expected=IllegalStateException.class)
    public void throwExceptionWithoutSettingUid() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        Configuration config = new Configuration();
        config.set(ExecutionOptions.RUNTIME_MODE, (Object)this.runtimeExecutionMode);
        env.configure((ReadableConfig)config, ((Object)((Object)this)).getClass().getClassLoader());
        env.getConfig().disableAutoGeneratedUIDs();
        this.sinkTo((DataStream<Integer>)env.fromElements((Object[])new Integer[]{1, 2}), this.simpleSink());
        env.getStreamGraph();
    }

    @Test
    public void disableOperatorChain() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource src = env.fromElements((Object[])new Integer[]{1, 2});
        DataStreamSink dataStreamSink = this.sinkTo((DataStream<Integer>)src, this.sinkWithCommitter()).name(NAME);
        dataStreamSink.disableChaining();
        StreamGraph streamGraph = env.getStreamGraph();
        StreamNode writer = this.findWriter(streamGraph);
        StreamNode committer = this.findCommitter(streamGraph);
        MatcherAssert.assertThat((Object)writer.getOperatorFactory().getChainingStrategy(), (Matcher)CoreMatchers.is((Object)ChainingStrategy.NEVER));
        MatcherAssert.assertThat((Object)committer.getOperatorFactory().getChainingStrategy(), (Matcher)CoreMatchers.is((Object)ChainingStrategy.NEVER));
    }

    void validateTopology(StreamNode src, Class<?> srcOutTypeInfo, StreamNode dest, Class<? extends StreamOperatorFactory> operatorFactoryClass, int expectedParallelism, int expectedMaxParallelism) {
        StreamEdge srcOutEdge = (StreamEdge)src.getOutEdges().get(0);
        MatcherAssert.assertThat((Object)srcOutEdge.getTargetId(), (Matcher)CoreMatchers.equalTo((Object)dest.getId()));
        MatcherAssert.assertThat((Object)src.getTypeSerializerOut(), (Matcher)CoreMatchers.instanceOf(srcOutTypeInfo));
        StreamEdge destInputEdge = (StreamEdge)dest.getInEdges().get(0);
        MatcherAssert.assertThat((Object)destInputEdge.getSourceId(), (Matcher)CoreMatchers.equalTo((Object)src.getId()));
        MatcherAssert.assertThat((Object)dest.getTypeSerializersIn()[0], (Matcher)CoreMatchers.instanceOf(srcOutTypeInfo));
        MatcherAssert.assertThat((Object)dest.getOperatorName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)src.getOperatorName())));
        MatcherAssert.assertThat((Object)dest.getTransformationUID(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)src.getTransformationUID())));
        MatcherAssert.assertThat((Object)dest.getOperatorFactory(), (Matcher)CoreMatchers.instanceOf(operatorFactoryClass));
        MatcherAssert.assertThat((Object)dest.getParallelism(), (Matcher)CoreMatchers.equalTo((Object)expectedParallelism));
        MatcherAssert.assertThat((Object)dest.getMaxParallelism(), (Matcher)CoreMatchers.equalTo((Object)expectedMaxParallelism));
        MatcherAssert.assertThat((Object)dest.getOperatorFactory().getChainingStrategy(), (Matcher)CoreMatchers.is((Object)ChainingStrategy.ALWAYS));
        MatcherAssert.assertThat((Object)dest.getSlotSharingGroup(), (Matcher)CoreMatchers.equalTo((Object)SLOT_SHARE_GROUP));
    }

    StreamGraph buildGraph(SinkT sink, RuntimeExecutionMode runtimeExecutionMode) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        Configuration config = new Configuration();
        config.set(ExecutionOptions.RUNTIME_MODE, (Object)runtimeExecutionMode);
        env.configure((ReadableConfig)config, ((Object)((Object)this)).getClass().getClassLoader());
        DataStreamSource src = env.fromElements((Object[])new Integer[]{1, 2});
        DataStreamSink<Integer> dataStreamSink = this.sinkTo((DataStream<Integer>)src.rebalance(), sink);
        this.setSinkProperty(dataStreamSink);
        env.getExecutionPlan();
        return env.getStreamGraph();
    }

    private void setSinkProperty(DataStreamSink<Integer> dataStreamSink) {
        dataStreamSink.name(NAME);
        dataStreamSink.uid(UID);
        dataStreamSink.setParallelism(2);
        dataStreamSink.slotSharingGroup(SLOT_SHARE_GROUP);
    }

    StreamNode findNodeName(StreamGraph streamGraph, Predicate<String> predicate) {
        return streamGraph.getStreamNodes().stream().filter(node -> predicate.test(node.getOperatorName())).findFirst().orElseThrow(() -> new IllegalStateException("Can not find the node"));
    }
}

