/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.operators.MultipleInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributes;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.streaming.util.AbstractStreamOperatorTestHarness;

public class MultiInputStreamOperatorTestHarness<OUT>
extends AbstractStreamOperatorTestHarness<OUT> {
    public MultiInputStreamOperatorTestHarness(StreamOperatorFactory<OUT> operator) throws Exception {
        this(operator, 1, 1, 0);
    }

    public MultiInputStreamOperatorTestHarness(StreamOperatorFactory<OUT> operatorFactory, int maxParallelism, int numSubtasks, int subtaskIndex) throws Exception {
        super(operatorFactory, maxParallelism, numSubtasks, subtaskIndex);
    }

    public void processElement(int idx, StreamRecord<?> element) throws Exception {
        Input input = (Input)this.getCastedOperator().getInputs().get(idx);
        input.setKeyContextElement(element);
        input.processElement(element);
    }

    public void processWatermark(int idx, Watermark mark) throws Exception {
        ((Input)this.getCastedOperator().getInputs().get(idx)).processWatermark(mark);
    }

    public void processWatermarkStatus(int idx, WatermarkStatus watermarkStatus) throws Exception {
        ((Input)this.getCastedOperator().getInputs().get(idx)).processWatermarkStatus(watermarkStatus);
    }

    public void processRecordAttributes(int idx, RecordAttributes recordAttributes) throws Exception {
        ((Input)this.getCastedOperator().getInputs().get(idx)).processRecordAttributes(recordAttributes);
    }

    private MultipleInputStreamOperator<OUT> getCastedOperator() {
        return (MultipleInputStreamOperator)this.operator;
    }
}

