/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.v2.DiscardingSink;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CheckpointExceptionHandlerConfigurationTest {
    CheckpointExceptionHandlerConfigurationTest() {
    }

    @Test
    void testCheckpointConfigDefault() {
        StreamExecutionEnvironment streamExecutionEnvironment = StreamExecutionEnvironment.getExecutionEnvironment();
        CheckpointConfig checkpointConfig = streamExecutionEnvironment.getCheckpointConfig();
        Assertions.assertThat((boolean)checkpointConfig.isFailOnCheckpointingErrors()).isTrue();
        Assertions.assertThat((int)checkpointConfig.getTolerableCheckpointFailureNumber()).isZero();
    }

    @Test
    void testSetCheckpointConfig() {
        StreamExecutionEnvironment streamExecutionEnvironment = StreamExecutionEnvironment.getExecutionEnvironment();
        CheckpointConfig checkpointConfig = streamExecutionEnvironment.getCheckpointConfig();
        checkpointConfig.setFailOnCheckpointingErrors(false);
        Assertions.assertThat((boolean)checkpointConfig.isFailOnCheckpointingErrors()).isFalse();
        Assertions.assertThat((int)checkpointConfig.getTolerableCheckpointFailureNumber()).isEqualTo(Integer.MAX_VALUE);
        checkpointConfig.setTolerableCheckpointFailureNumber(5);
        Assertions.assertThat((int)checkpointConfig.getTolerableCheckpointFailureNumber()).isEqualTo(5);
        checkpointConfig.setFailOnCheckpointingErrors(true);
        Assertions.assertThat((int)checkpointConfig.getTolerableCheckpointFailureNumber()).isEqualTo(5);
    }

    @Test
    void testPropagationFailFromCheckpointConfig() {
        try {
            this.doTestPropagationFromCheckpointConfig(true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testPropagationDeclineFromCheckpointConfig() {
        this.doTestPropagationFromCheckpointConfig(false);
    }

    public void doTestPropagationFromCheckpointConfig(boolean failTaskOnCheckpointErrors) {
        StreamExecutionEnvironment streamExecutionEnvironment = StreamExecutionEnvironment.getExecutionEnvironment();
        streamExecutionEnvironment.setParallelism(1);
        streamExecutionEnvironment.getCheckpointConfig().setCheckpointInterval(1000L);
        streamExecutionEnvironment.getCheckpointConfig().setFailOnCheckpointingErrors(failTaskOnCheckpointErrors);
        streamExecutionEnvironment.addSource((SourceFunction)new SourceFunction<Integer>(){

            public void run(SourceFunction.SourceContext<Integer> ctx) {
            }

            public void cancel() {
            }
        }).sinkTo((Sink)new DiscardingSink());
    }
}

