/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;
import org.apache.flink.streaming.api.transformations.WithBoundedness;
import org.apache.flink.util.Preconditions;

@Internal
public class LegacySourceTransformation<T>
extends PhysicalTransformation<T>
implements WithBoundedness {
    private final StreamOperatorFactory<T> operatorFactory;
    private Boundedness boundedness;

    public LegacySourceTransformation(String name, StreamSource<T, ?> operator, TypeInformation<T> outputType, int parallelism, Boundedness boundedness, boolean parallelismConfigured) {
        super(name, outputType, parallelism, parallelismConfigured);
        this.operatorFactory = (StreamOperatorFactory)Preconditions.checkNotNull(SimpleOperatorFactory.of(operator));
        this.boundedness = (Boundedness)Preconditions.checkNotNull((Object)boundedness);
    }

    public void setBoundedness(Boundedness boundedness) {
        this.boundedness = boundedness;
    }

    @Override
    public Boundedness getBoundedness() {
        return this.boundedness;
    }

    @VisibleForTesting
    public StreamSource<T, ?> getOperator() {
        return (StreamSource)((SimpleOperatorFactory)this.operatorFactory).getOperator();
    }

    public StreamOperatorFactory<T> getOperatorFactory() {
        return this.operatorFactory;
    }

    protected List<Transformation<?>> getTransitivePredecessorsInternal() {
        return Collections.singletonList(this);
    }

    public List<Transformation<?>> getInputs() {
        return Collections.emptyList();
    }

    @Override
    public final void setChainingStrategy(ChainingStrategy strategy) {
        this.operatorFactory.setChainingStrategy(strategy);
    }
}

