/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.deltafunction;

import org.apache.flink.streaming.api.functions.windowing.delta.CosineDistance;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CosineDistanceTest {
    CosineDistanceTest() {
    }

    @Test
    void testCosineDistance() {
        double[][][] testdata = new double[][][]{new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0}, {1.0, 2.0, 3.0}}, new double[][]{{1.0, 2.0, 3.0}, {0.0, 0.0, 0.0}}, new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}}, new double[][]{{1.0, 2.0, 3.0}, {-4.0, -5.0, -6.0}}, new double[][]{{1.0, 2.0, -3.0}, {-4.0, 5.0, -6.0}}, new double[][]{{1.0, 2.0, 3.0, 4.0}, {5.0, 6.0, 7.0, 8.0}}, new double[][]{{1.0, 2.0}, {3.0, 4.0}}, new double[][]{{1.0}, {2.0}}};
        double[] referenceSolutions = new double[]{0.0, 0.0, 0.0, 0.025368, 1.974631, 0.269026, 0.031136, 0.01613, 0.0};
        for (int i = 0; i < testdata.length; ++i) {
            ((AbstractDoubleAssert)Assertions.assertThat((double)new CosineDistance().getDelta((Object)testdata[i][0], (Object)testdata[i][1])).as("Wrong result for inputs " + this.arrayToString(testdata[i][0]) + " and " + this.arrayToString(testdata[i][0]), new Object[0])).isCloseTo(referenceSolutions[i], Assertions.offset((Double)1.0E-6));
        }
    }

    private String arrayToString(double[] in) {
        if (in.length == 0) {
            return "{}";
        }
        String result = "{";
        for (double d : in) {
            result = result + d + ",";
        }
        return result.substring(0, result.length() - 1) + "}";
    }
}

