/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamrecord;

import java.io.IOException;
import java.util.Collections;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.watermark.InternalWatermark;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributes;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributesBuilder;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class StreamElementSerializerTest {
    StreamElementSerializerTest() {
    }

    @Test
    void testDeepDuplication() {
        TypeSerializer serializer1 = (TypeSerializer)Mockito.mock(TypeSerializer.class);
        TypeSerializer serializer2 = (TypeSerializer)Mockito.mock(TypeSerializer.class);
        Mockito.when((Object)serializer1.duplicate()).thenReturn((Object)serializer2);
        StreamElementSerializer streamRecSer = new StreamElementSerializer(serializer1);
        Assertions.assertThat((Object)streamRecSer.getContainedTypeSerializer()).isEqualTo((Object)serializer1);
        StreamElementSerializer copy = streamRecSer.duplicate();
        Assertions.assertThat((Object)copy).isNotEqualTo((Object)streamRecSer);
        Assertions.assertThat((Object)copy.getContainedTypeSerializer()).isNotEqualTo((Object)streamRecSer.getContainedTypeSerializer());
    }

    @Test
    void testBasicProperties() {
        StreamElementSerializer streamRecSer = new StreamElementSerializer((TypeSerializer)LongSerializer.INSTANCE);
        Assertions.assertThat((boolean)streamRecSer.isImmutableType()).isFalse();
        Assertions.assertThat((Long)((Long)streamRecSer.createInstance().getValue())).isExactlyInstanceOf(Long.class);
        Assertions.assertThat((int)streamRecSer.getLength()).isEqualTo(-1L);
    }

    @Test
    void testSerialization() throws Exception {
        StreamElementSerializer serializer = new StreamElementSerializer((TypeSerializer)StringSerializer.INSTANCE);
        StreamRecord withoutTimestamp = new StreamRecord((Object)"test 1 2 \u5206\u4eab\u57fa\u7763\u8036\u7a4c\u7684\u611b\u7d66\u5011\uff0c\u958b\u62d3\u96d9\u8d0f!");
        Assertions.assertThat((Object)StreamElementSerializerTest.serializeAndDeserialize(withoutTimestamp, serializer)).isEqualTo((Object)withoutTimestamp);
        StreamRecord withTimestamp = new StreamRecord((Object)"one more test \u62d3 \u5011 \u5206", 77L);
        Assertions.assertThat((Object)StreamElementSerializerTest.serializeAndDeserialize(withTimestamp, serializer)).isEqualTo((Object)withTimestamp);
        StreamRecord negativeTimestamp = new StreamRecord((Object)"\u4ed6", Long.MIN_VALUE);
        Assertions.assertThat((Object)StreamElementSerializerTest.serializeAndDeserialize(negativeTimestamp, serializer)).isEqualTo((Object)negativeTimestamp);
        Watermark positiveWatermark = new Watermark(13L);
        Assertions.assertThat((Object)StreamElementSerializerTest.serializeAndDeserialize(positiveWatermark, serializer)).isEqualTo((Object)positiveWatermark);
        Watermark negativeWatermark = new Watermark(-4647654567676555876L);
        Assertions.assertThat((Object)StreamElementSerializerTest.serializeAndDeserialize(negativeWatermark, serializer)).isEqualTo((Object)negativeWatermark);
        InternalWatermark internalWatermark = new InternalWatermark(13L, 10);
        Assertions.assertThat((Object)StreamElementSerializerTest.serializeAndDeserialize(internalWatermark, serializer)).isEqualTo((Object)internalWatermark);
        LatencyMarker latencyMarker = new LatencyMarker(System.currentTimeMillis(), new OperatorID(-1L, -1L), 1);
        Assertions.assertThat((Object)StreamElementSerializerTest.serializeAndDeserialize(latencyMarker, serializer)).isEqualTo((Object)latencyMarker);
        RecordAttributes recordAttributes = new RecordAttributesBuilder(Collections.emptyList()).setBacklog(true).build();
        Assertions.assertThat((Object)StreamElementSerializerTest.serializeAndDeserialize(recordAttributes, serializer)).isEqualTo((Object)recordAttributes);
    }

    private static <T, X extends StreamElement> X serializeAndDeserialize(X record, StreamElementSerializer<T> serializer) throws IOException {
        DataOutputSerializer output = new DataOutputSerializer(32);
        serializer.serialize(record, (DataOutputView)output);
        DataInputDeserializer copyInput = new DataInputDeserializer(output.getByteArray(), 0, output.length());
        DataOutputSerializer copyOutput = new DataOutputSerializer(32);
        serializer.copy((DataInputView)copyInput, (DataOutputView)copyOutput);
        DataInputDeserializer input = new DataInputDeserializer(copyOutput.getByteArray(), 0, copyOutput.length());
        return (X)serializer.deserialize((DataInputView)input);
    }
}

