/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.async.queue;

import java.util.Arrays;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.operators.async.queue.QueueUtil;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueue;
import org.apache.flink.streaming.api.operators.async.queue.UnorderedStreamElementQueue;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class UnorderedStreamElementQueueTest {
    UnorderedStreamElementQueueTest() {
    }

    @Test
    void testCompletionOrder() {
        UnorderedStreamElementQueue queue = new UnorderedStreamElementQueue(8);
        ResultFuture<Integer> record1 = QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new StreamRecord((Object)1, 0L));
        ResultFuture<Integer> record2 = QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new StreamRecord((Object)2, 1L));
        QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new Watermark(2L));
        ResultFuture<Integer> record3 = QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new StreamRecord((Object)3, 3L));
        ResultFuture<Integer> record4 = QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new StreamRecord((Object)4, 4L));
        QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new Watermark(5L));
        ResultFuture<Integer> record5 = QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new StreamRecord((Object)5, 6L));
        ResultFuture<Integer> record6 = QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new StreamRecord((Object)6, 7L));
        Assertions.assertThat(QueueUtil.popCompleted((StreamElementQueue<Integer>)queue)).isEmpty();
        Assertions.assertThat((int)queue.size()).isEqualTo(8);
        Assertions.assertThat((boolean)queue.isEmpty()).isFalse();
        record3.complete(Arrays.asList(13));
        Assertions.assertThat(QueueUtil.popCompleted((StreamElementQueue<Integer>)queue)).isEmpty();
        Assertions.assertThat((int)queue.size()).isEqualTo(8);
        Assertions.assertThat((boolean)queue.isEmpty()).isFalse();
        record2.complete(Arrays.asList(12));
        Assertions.assertThat(QueueUtil.popCompleted((StreamElementQueue<Integer>)queue)).containsExactly((Object[])new StreamElement[]{new StreamRecord((Object)12, 1L)});
        Assertions.assertThat((int)queue.size()).isEqualTo(7);
        Assertions.assertThat((boolean)queue.isEmpty()).isFalse();
        record6.complete(Arrays.asList(16));
        record4.complete(Arrays.asList(14));
        Assertions.assertThat(QueueUtil.popCompleted((StreamElementQueue<Integer>)queue)).isEmpty();
        Assertions.assertThat((int)queue.size()).isEqualTo(7);
        Assertions.assertThat((boolean)queue.isEmpty()).isFalse();
        record1.complete(Arrays.asList(11));
        Assertions.assertThat(QueueUtil.popCompleted((StreamElementQueue<Integer>)queue)).containsExactly((Object[])new StreamElement[]{new StreamRecord((Object)11, 0L), new Watermark(2L), new StreamRecord((Object)13, 3L), new StreamRecord((Object)14, 4L), new Watermark(5L), new StreamRecord((Object)16, 7L)});
        Assertions.assertThat((int)queue.size()).isOne();
        Assertions.assertThat((boolean)queue.isEmpty()).isFalse();
        record5.complete(Arrays.asList(15));
        Assertions.assertThat(QueueUtil.popCompleted((StreamElementQueue<Integer>)queue)).containsExactly((Object[])new StreamElement[]{new StreamRecord((Object)15, 6L)});
        Assertions.assertThat((int)queue.size()).isZero();
        Assertions.assertThat((boolean)queue.isEmpty()).isTrue();
        Assertions.assertThat(QueueUtil.popCompleted((StreamElementQueue<Integer>)queue)).isEmpty();
    }
}

