/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.time.Duration;
import java.util.Collection;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.shaded.guava32.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.windowing.triggers.ContinuousEventTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.TriggerTestHarness;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ContinuousEventTimeTriggerTest {
    ContinuousEventTimeTriggerTest() {
    }

    @Test
    void testTriggerHandlesAllOnTimerCalls() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness((Trigger)ContinuousEventTimeTrigger.of((Duration)Duration.ofMillis(5L)), (TypeSerializer)new TimeWindow.Serializer());
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        testHarness.advanceWatermark(10L);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.FIRE);
        testHarness.invokeOnEventTime(20L, (Window)new TimeWindow(0L, 2L));
    }

    @Test
    void testWindowSeparationAndFiring() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness((Trigger)ContinuousEventTimeTrigger.of((Duration)Duration.ofHours(1L)), (TypeSerializer)new TimeWindow.Serializer());
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(2L, 4L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(2L, 4L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isEqualTo(4);
        Assertions.assertThat((int)testHarness.numEventTimeTimers((Window)new TimeWindow(0L, 2L))).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numEventTimeTimers((Window)new TimeWindow(2L, 4L))).isEqualTo(2);
        Collection triggerResults = testHarness.advanceWatermark(2L);
        boolean sawFiring = false;
        for (Tuple2 r : triggerResults) {
            if (!((TimeWindow)r.f0).equals((Object)new TimeWindow(0L, 2L))) continue;
            sawFiring = true;
            Assertions.assertThat((Comparable)((TriggerResult)r.f1)).isEqualTo((Object)TriggerResult.FIRE);
        }
        Assertions.assertThat((boolean)sawFiring).isTrue();
        Assertions.assertThat((int)testHarness.numStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isEqualTo(3);
        Assertions.assertThat((int)testHarness.numEventTimeTimers((Window)new TimeWindow(0L, 2L))).isOne();
        Assertions.assertThat((int)testHarness.numEventTimeTimers((Window)new TimeWindow(2L, 4L))).isEqualTo(2);
        triggerResults = testHarness.advanceWatermark(4L);
        sawFiring = false;
        for (Tuple2 r : triggerResults) {
            if (!((TimeWindow)r.f0).equals((Object)new TimeWindow(2L, 4L))) continue;
            sawFiring = true;
            Assertions.assertThat((Comparable)((TriggerResult)r.f1)).isEqualTo((Object)TriggerResult.FIRE);
        }
        Assertions.assertThat((boolean)sawFiring).isTrue();
        Assertions.assertThat((int)testHarness.numStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isEqualTo(2);
    }

    @Test
    void testLateElementTriggersImmediately() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness((Trigger)ContinuousEventTimeTrigger.of((Duration)Duration.ofHours(1L)), (TypeSerializer)new TimeWindow.Serializer());
        testHarness.advanceWatermark(2L);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.FIRE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
    }

    @Test
    void testClear() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness((Trigger)ContinuousEventTimeTrigger.of((Duration)Duration.ofHours(1L)), (TypeSerializer)new TimeWindow.Serializer());
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(2L, 4L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isEqualTo(4);
        Assertions.assertThat((int)testHarness.numEventTimeTimers((Window)new TimeWindow(0L, 2L))).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numEventTimeTimers((Window)new TimeWindow(2L, 4L))).isEqualTo(2);
        testHarness.clearTriggerState((Window)new TimeWindow(2L, 4L));
        Assertions.assertThat((int)testHarness.numStateEntries()).isOne();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isEqualTo(3);
        Assertions.assertThat((int)testHarness.numEventTimeTimers((Window)new TimeWindow(0L, 2L))).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numEventTimeTimers((Window)new TimeWindow(2L, 4L))).isOne();
        testHarness.clearTriggerState((Window)new TimeWindow(0L, 2L));
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isEqualTo(2);
    }

    @Test
    void testMergingWindows() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness((Trigger)ContinuousEventTimeTrigger.of((Duration)Duration.ofHours(1L)), (TypeSerializer)new TimeWindow.Serializer());
        Assertions.assertThat((boolean)ContinuousEventTimeTrigger.of((Duration)Duration.ofHours(1L)).canMerge()).isTrue();
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(2L, 4L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isEqualTo(4);
        Assertions.assertThat((int)testHarness.numEventTimeTimers((Window)new TimeWindow(0L, 2L))).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numEventTimeTimers((Window)new TimeWindow(2L, 4L))).isEqualTo(2);
        testHarness.mergeWindows((Window)new TimeWindow(0L, 4L), (Collection)Lists.newArrayList((Object[])new TimeWindow[]{new TimeWindow(0L, 2L), new TimeWindow(2L, 4L)}));
        Assertions.assertThat((int)testHarness.numStateEntries()).isOne();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isEqualTo(5);
        Assertions.assertThat((int)testHarness.numEventTimeTimers((Window)new TimeWindow(0L, 2L))).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numEventTimeTimers((Window)new TimeWindow(2L, 4L))).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numEventTimeTimers((Window)new TimeWindow(0L, 4L))).isOne();
        Collection triggerResults = testHarness.advanceWatermark(4L);
        boolean sawFiring = false;
        for (Tuple2 r : triggerResults) {
            if (!((TimeWindow)r.f0).equals((Object)new TimeWindow(0L, 4L))) continue;
            sawFiring = true;
            Assertions.assertThat((Comparable)((TriggerResult)r.f1)).isEqualTo((Object)TriggerResult.FIRE);
        }
        Assertions.assertThat((boolean)sawFiring).isTrue();
        Assertions.assertThat((int)testHarness.numStateEntries()).isOne();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isOne();
    }
}

