/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.shaded.guava32.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.windowing.assigners.EventTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.MergingWindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.MergingWindowSet;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class MergingWindowSetTest {
    MergingWindowSetTest() {
    }

    @Test
    void testNonEagerMerging() throws Exception {
        ListState mockState = (ListState)Mockito.mock(ListState.class);
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)new NonEagerlyMergingWindowAssigner(3000L), mockState);
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        mergeFunction.reset();
        TimeWindow result = (TimeWindow)windowSet.addWindow((Window)new TimeWindow(0L, 2L), (MergingWindowSet.MergeFunction)mergeFunction);
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)result))).isNotNull();
        mergeFunction.reset();
        result = (TimeWindow)windowSet.addWindow((Window)new TimeWindow(2L, 5L), (MergingWindowSet.MergeFunction)mergeFunction);
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)result))).isNotNull();
        mergeFunction.reset();
        result = (TimeWindow)windowSet.addWindow((Window)new TimeWindow(1L, 2L), (MergingWindowSet.MergeFunction)mergeFunction);
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)result))).isNotNull();
        mergeFunction.reset();
        result = (TimeWindow)windowSet.addWindow((Window)new TimeWindow(10L, 12L), (MergingWindowSet.MergeFunction)mergeFunction);
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)result))).isNotNull();
    }

    @Test
    void testIncrementalMerging() throws Exception {
        ListState mockState = (ListState)Mockito.mock(ListState.class);
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)EventTimeSessionWindows.withGap((Duration)Duration.ofMillis(3L)), mockState);
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(0L, 4L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(0L, 4L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(0L, 4L)))).isEqualTo((Object)new TimeWindow(0L, 4L));
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(0L, 4L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(0L, 4L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(3L, 5L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(0L, 5L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isTrue();
        Assertions.assertThat((Object)mergeFunction.mergeTarget()).isEqualTo((Object)new TimeWindow(0L, 5L));
        Assertions.assertThat((Object)mergeFunction.stateWindow()).isEqualTo((Object)new TimeWindow(0L, 4L));
        Assertions.assertThat(mergeFunction.mergeSources()).containsExactly((Object[])new TimeWindow[]{new TimeWindow(0L, 4L)});
        Assertions.assertThat(mergeFunction.mergedStateWindows()).isEmpty();
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(4L, 6L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(0L, 6L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isTrue();
        Assertions.assertThat((Object)mergeFunction.mergeTarget()).isEqualTo((Object)new TimeWindow(0L, 6L));
        Assertions.assertThat((Object)mergeFunction.stateWindow()).isEqualTo((Object)new TimeWindow(0L, 4L));
        Assertions.assertThat(mergeFunction.mergeSources()).containsExactly((Object[])new TimeWindow[]{new TimeWindow(0L, 5L)});
        Assertions.assertThat(mergeFunction.mergedStateWindows()).isEmpty();
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(0L, 6L)))).isEqualTo((Object)new TimeWindow(0L, 4L));
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(1L, 4L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(0L, 6L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(0L, 4L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(0L, 6L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(3L, 5L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(0L, 6L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(4L, 6L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(0L, 6L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(0L, 6L)))).isEqualTo((Object)new TimeWindow(0L, 4L));
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(11L, 14L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(11L, 14L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(0L, 6L)))).isEqualTo((Object)new TimeWindow(0L, 4L));
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(11L, 14L)))).isEqualTo((Object)new TimeWindow(11L, 14L));
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(10L, 13L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(10L, 14L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isTrue();
        Assertions.assertThat((Object)mergeFunction.mergeTarget()).isEqualTo((Object)new TimeWindow(10L, 14L));
        Assertions.assertThat((Object)mergeFunction.stateWindow()).isEqualTo((Object)new TimeWindow(11L, 14L));
        Assertions.assertThat(mergeFunction.mergeSources()).containsExactly((Object[])new TimeWindow[]{new TimeWindow(11L, 14L)});
        Assertions.assertThat(mergeFunction.mergedStateWindows()).isEmpty();
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(12L, 15L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(10L, 15L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isTrue();
        Assertions.assertThat((Object)mergeFunction.mergeTarget()).isEqualTo((Object)new TimeWindow(10L, 15L));
        Assertions.assertThat((Object)mergeFunction.stateWindow()).isEqualTo((Object)new TimeWindow(11L, 14L));
        Assertions.assertThat(mergeFunction.mergeSources()).containsExactly((Object[])new TimeWindow[]{new TimeWindow(10L, 14L)});
        Assertions.assertThat(mergeFunction.mergedStateWindows()).isEmpty();
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(11L, 14L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(10L, 15L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(0L, 6L)))).isEqualTo((Object)new TimeWindow(0L, 4L));
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(10L, 15L)))).isEqualTo((Object)new TimeWindow(11L, 14L));
        windowSet.retireWindow((Window)new TimeWindow(0L, 6L));
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(0L, 6L)))).isNull();
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(10L, 15L)))).isEqualTo((Object)new TimeWindow(11L, 14L));
    }

    @Test
    void testLateMerging() throws Exception {
        ListState mockState = (ListState)Mockito.mock(ListState.class);
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)EventTimeSessionWindows.withGap((Duration)Duration.ofMillis(3L)), mockState);
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(0L, 3L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(0L, 3L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(0L, 3L)))).isEqualTo((Object)new TimeWindow(0L, 3L));
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(5L, 8L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(5L, 8L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(5L, 8L)))).isEqualTo((Object)new TimeWindow(5L, 8L));
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(10L, 13L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(10L, 13L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(10L, 13L)))).isEqualTo((Object)new TimeWindow(10L, 13L));
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(8L, 10L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(5L, 13L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isTrue();
        Assertions.assertThat((Object)mergeFunction.mergeTarget()).isEqualTo((Object)new TimeWindow(5L, 13L));
        Assertions.assertThat((Object)mergeFunction.stateWindow()).satisfiesAnyOf(new ThrowingConsumer[]{w -> Assertions.assertThat((Object)w).isEqualTo((Object)new TimeWindow(5L, 8L)), w -> Assertions.assertThat((Object)w).isEqualTo((Object)new TimeWindow(10L, 13L))});
        Assertions.assertThat(mergeFunction.mergeSources()).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(5L, 8L), new TimeWindow(10L, 13L)});
        Assertions.assertThat(mergeFunction.mergedStateWindows()).containsAnyOf((Object[])new TimeWindow[]{new TimeWindow(5L, 8L), new TimeWindow(10L, 13L)});
        Assertions.assertThat((Object[])mergeFunction.mergedStateWindows().toArray()).satisfiesAnyOf(new ThrowingConsumer[]{o -> Assertions.assertThat((Object[])o).containsExactly(new Object[]{new TimeWindow(10L, 13L)}), o -> Assertions.assertThat((Object[])o).containsExactly(new Object[]{new TimeWindow(5L, 8L)})});
        Assertions.assertThat(mergeFunction.mergedStateWindows()).doesNotContain((Object[])new TimeWindow[]{mergeFunction.mergeTarget()});
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(0L, 3L)))).isEqualTo((Object)new TimeWindow(0L, 3L));
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(5L, 8L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(5L, 13L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(8L, 10L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(5L, 13L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(10L, 13L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(5L, 13L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(5L, 13L)))).isIn(new Object[]{new TimeWindow(5L, 8L), new TimeWindow(10L, 13L)});
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(3L, 5L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(0L, 13L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isTrue();
        Assertions.assertThat((Object)mergeFunction.mergeTarget()).isEqualTo((Object)new TimeWindow(0L, 13L));
        Assertions.assertThat((Object)mergeFunction.stateWindow()).isIn(new Object[]{new TimeWindow(0L, 3L), new TimeWindow(5L, 8L), new TimeWindow(10L, 13L)});
        Assertions.assertThat(mergeFunction.mergeSources()).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 3L), new TimeWindow(5L, 13L)});
        Assertions.assertThat((Object[])mergeFunction.mergedStateWindows().toArray()).satisfiesAnyOf(new ThrowingConsumer[]{o -> Assertions.assertThat((Object[])o).containsExactly(new Object[]{new TimeWindow(0L, 3L)}), o -> Assertions.assertThat((Object[])o).containsExactly(new Object[]{new TimeWindow(5L, 8L)}), o -> Assertions.assertThat((Object[])o).containsExactly(new Object[]{new TimeWindow(10L, 13L)})});
        Assertions.assertThat(mergeFunction.mergedStateWindows()).doesNotContain((Object[])new TimeWindow[]{mergeFunction.mergeTarget()});
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(0L, 13L)))).isIn(new Object[]{new TimeWindow(0L, 3L), new TimeWindow(5L, 8L), new TimeWindow(10L, 13L)});
    }

    @Test
    void testMergeLargeWindowCoveringSingleWindow() throws Exception {
        ListState mockState = (ListState)Mockito.mock(ListState.class);
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)EventTimeSessionWindows.withGap((Duration)Duration.ofMillis(3L)), mockState);
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(1L, 2L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(1L, 2L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(1L, 2L)))).isEqualTo((Object)new TimeWindow(1L, 2L));
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(0L, 3L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(0L, 3L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isTrue();
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(0L, 3L)))).isEqualTo((Object)new TimeWindow(1L, 2L));
    }

    @Test
    void testAddingIdenticalWindows() throws Exception {
        ListState mockState = (ListState)Mockito.mock(ListState.class);
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)EventTimeSessionWindows.withGap((Duration)Duration.ofMillis(3L)), mockState);
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(1L, 2L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(1L, 2L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(1L, 2L)))).isEqualTo((Object)new TimeWindow(1L, 2L));
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(1L, 2L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(1L, 2L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(1L, 2L)))).isEqualTo((Object)new TimeWindow(1L, 2L));
    }

    @Test
    void testMergeLargeWindowCoveringMultipleWindows() throws Exception {
        ListState mockState = (ListState)Mockito.mock(ListState.class);
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)EventTimeSessionWindows.withGap((Duration)Duration.ofMillis(3L)), mockState);
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(1L, 3L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(1L, 3L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(1L, 3L)))).isEqualTo((Object)new TimeWindow(1L, 3L));
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(5L, 8L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(5L, 8L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(5L, 8L)))).isEqualTo((Object)new TimeWindow(5L, 8L));
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(10L, 13L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(10L, 13L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isFalse();
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(10L, 13L)))).isEqualTo((Object)new TimeWindow(10L, 13L));
        mergeFunction.reset();
        Assertions.assertThat((Object)((TimeWindow)windowSet.addWindow((Window)new TimeWindow(0L, 13L), (MergingWindowSet.MergeFunction)mergeFunction))).isEqualTo((Object)new TimeWindow(0L, 13L));
        Assertions.assertThat((boolean)mergeFunction.hasMerged()).isTrue();
        Assertions.assertThat((Object[])mergeFunction.mergedStateWindows().toArray()).satisfiesAnyOf(new ThrowingConsumer[]{o -> Assertions.assertThat((Object[])o).containsExactlyInAnyOrder(new Object[]{new TimeWindow(0L, 3L), new TimeWindow(5L, 8L)}), o -> Assertions.assertThat((Object[])o).containsExactlyInAnyOrder(new Object[]{new TimeWindow(0L, 3L), new TimeWindow(10L, 13L)}), o -> Assertions.assertThat((Object[])o).containsExactlyInAnyOrder(new Object[]{new TimeWindow(5L, 8L), new TimeWindow(10L, 13L)})});
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(0L, 13L)))).isIn(new Object[]{new TimeWindow(1L, 3L), new TimeWindow(5L, 8L), new TimeWindow(10L, 13L)});
    }

    @Test
    void testRestoreFromState() throws Exception {
        ListState mockState = (ListState)Mockito.mock(ListState.class);
        Mockito.when((Object)((Iterable)mockState.get())).thenReturn((Object)Lists.newArrayList((Object[])new Tuple2[]{new Tuple2((Object)new TimeWindow(17L, 42L), (Object)new TimeWindow(42L, 17L)), new Tuple2((Object)new TimeWindow(1L, 2L), (Object)new TimeWindow(3L, 4L))}));
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)EventTimeSessionWindows.withGap((Duration)Duration.ofMillis(3L)), mockState);
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(17L, 42L)))).isEqualTo((Object)new TimeWindow(42L, 17L));
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(1L, 2L)))).isEqualTo((Object)new TimeWindow(3L, 4L));
    }

    @Test
    void testPersist() throws Exception {
        ListState mockState = (ListState)Mockito.mock(ListState.class);
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)EventTimeSessionWindows.withGap((Duration)Duration.ofMillis(3L)), mockState);
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        windowSet.addWindow((Window)new TimeWindow(1L, 2L), (MergingWindowSet.MergeFunction)mergeFunction);
        windowSet.addWindow((Window)new TimeWindow(17L, 42L), (MergingWindowSet.MergeFunction)mergeFunction);
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(1L, 2L)))).isEqualTo((Object)new TimeWindow(1L, 2L));
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(17L, 42L)))).isEqualTo((Object)new TimeWindow(17L, 42L));
        windowSet.persist();
        ((ListState)Mockito.verify((Object)mockState)).update((List)Matchers.eq(new ArrayList<Tuple2>(Arrays.asList(new Tuple2((Object)new TimeWindow(1L, 2L), (Object)new TimeWindow(1L, 2L)), new Tuple2((Object)new TimeWindow(17L, 42L), (Object)new TimeWindow(17L, 42L))))));
        ((ListState)Mockito.verify((Object)mockState, (VerificationMode)Mockito.times((int)1))).update((List)Matchers.anyObject());
    }

    @Test
    void testPersistOnlyIfHaveUpdates() throws Exception {
        ListState mockState = (ListState)Mockito.mock(ListState.class);
        Mockito.when((Object)((Iterable)mockState.get())).thenReturn((Object)Lists.newArrayList((Object[])new Tuple2[]{new Tuple2((Object)new TimeWindow(17L, 42L), (Object)new TimeWindow(42L, 17L)), new Tuple2((Object)new TimeWindow(1L, 2L), (Object)new TimeWindow(3L, 4L))}));
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)EventTimeSessionWindows.withGap((Duration)Duration.ofMillis(3L)), mockState);
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(17L, 42L)))).isEqualTo((Object)new TimeWindow(42L, 17L));
        Assertions.assertThat((Object)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(1L, 2L)))).isEqualTo((Object)new TimeWindow(3L, 4L));
        windowSet.persist();
        ((ListState)Mockito.verify((Object)mockState, (VerificationMode)Mockito.times((int)0))).add((Object)((Tuple2)Matchers.anyObject()));
    }

    static class NonEagerlyMergingWindowAssigner
    extends MergingWindowAssigner<Object, TimeWindow> {
        private static final long serialVersionUID = 1L;
        protected long sessionTimeout;

        public NonEagerlyMergingWindowAssigner(long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        public Collection<TimeWindow> assignWindows(Object element, long timestamp, WindowAssigner.WindowAssignerContext context) {
            return Collections.singletonList(new TimeWindow(timestamp, timestamp + this.sessionTimeout));
        }

        public Trigger<Object, TimeWindow> getDefaultTrigger() {
            return EventTimeTrigger.create();
        }

        public TypeSerializer<TimeWindow> getWindowSerializer(ExecutionConfig executionConfig) {
            return new TimeWindow.Serializer();
        }

        public boolean isEventTime() {
            return true;
        }

        public void mergeWindows(Collection<TimeWindow> windows, MergingWindowAssigner.MergeCallback<TimeWindow> c) {
            TimeWindow earliestStart = null;
            for (TimeWindow timeWindow : windows) {
                if (earliestStart == null) {
                    earliestStart = timeWindow;
                    continue;
                }
                if (timeWindow.getStart() >= earliestStart.getStart()) continue;
                earliestStart = timeWindow;
            }
            ArrayList<TimeWindow> associatedWindows = new ArrayList<TimeWindow>();
            for (TimeWindow win : windows) {
                if (win.getStart() >= earliestStart.getEnd() || win.getStart() < earliestStart.getStart()) continue;
                associatedWindows.add(win);
            }
            TimeWindow timeWindow = new TimeWindow(earliestStart.getStart(), earliestStart.getEnd() + 1L);
            if (associatedWindows.size() > 1) {
                c.merge(associatedWindows, (Object)timeWindow);
            }
        }
    }

    private static class TestingMergeFunction
    implements MergingWindowSet.MergeFunction<TimeWindow> {
        private TimeWindow target = null;
        private Collection<TimeWindow> sources = null;
        private TimeWindow stateWindow = null;
        private Collection<TimeWindow> mergedStateWindows = null;

        private TestingMergeFunction() {
        }

        public void reset() {
            this.target = null;
            this.sources = null;
            this.stateWindow = null;
            this.mergedStateWindows = null;
        }

        public boolean hasMerged() {
            return this.target != null;
        }

        public TimeWindow mergeTarget() {
            return this.target;
        }

        public Collection<TimeWindow> mergeSources() {
            return this.sources;
        }

        public TimeWindow stateWindow() {
            return this.stateWindow;
        }

        public Collection<TimeWindow> mergedStateWindows() {
            return this.mergedStateWindows;
        }

        public void merge(TimeWindow mergeResult, Collection<TimeWindow> mergedWindows, TimeWindow stateWindowResult, Collection<TimeWindow> mergedStateWindows) throws Exception {
            ((ObjectAssert)Assertions.assertThat((Object)this.target).as("More than one merge for adding a Window should not occur.", new Object[0])).isNull();
            this.stateWindow = stateWindowResult;
            this.target = mergeResult;
            this.mergedStateWindows = mergedStateWindows;
            this.sources = mergedWindows;
        }
    }
}

