/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import org.apache.flink.streaming.runtime.operators.windowing.KeyMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class KeyMapPutIfAbsentTest {
    KeyMapPutIfAbsentTest() {
    }

    @Test
    void testPutIfAbsentUniqueKeysAndGrowth() {
        int i;
        KeyMap map = new KeyMap();
        IntegerFactory factory = new IntegerFactory();
        int numElements = 1000000;
        for (i = 0; i < 1000000; ++i) {
            factory.set(2 * i + 1);
            map.putIfAbsent((Object)i, (KeyMap.LazyFactory)factory);
            Assertions.assertThat((int)map.size()).isEqualTo(i + 1).isLessThanOrEqualTo(map.getRehashThreshold());
            Assertions.assertThat((int)map.getCurrentTableCapacity()).isGreaterThan(map.size()).isGreaterThan(map.getRehashThreshold());
        }
        Assertions.assertThat((Iterable)map).hasSize(1000000);
        Assertions.assertThat((int)map.traverseAndCountElements()).isEqualTo(1000000);
        Assertions.assertThat((int)map.getCurrentTableCapacity()).isEqualTo(0x200000);
        for (i = 0; i < 1000000; ++i) {
            Assertions.assertThat((Integer)((Integer)map.get((Object)i))).isEqualTo(2 * i + 1);
        }
        for (i = 999999; i >= 0; --i) {
            Assertions.assertThat((Integer)((Integer)map.get((Object)i))).isEqualTo(2 * i + 1);
        }
        Assertions.assertThat((Iterable)map).hasSize(1000000);
        Assertions.assertThat((int)map.traverseAndCountElements()).isEqualTo(1000000);
        Assertions.assertThat((int)map.getCurrentTableCapacity()).isEqualTo(0x200000);
        Assertions.assertThat((int)map.getLongestChainLength()).isLessThanOrEqualTo(7);
    }

    @Test
    void testPutIfAbsentDuplicateKeysAndGrowth() {
        int i;
        KeyMap map = new KeyMap();
        IntegerFactory factory = new IntegerFactory();
        int numElements = 1000000;
        for (i = 0; i < 1000000; ++i) {
            int val = 2 * i + 1;
            factory.set(val);
            Integer put = (Integer)map.putIfAbsent((Object)i, (KeyMap.LazyFactory)factory);
            Assertions.assertThat((Integer)put).isEqualTo(val);
        }
        for (i = 0; i < 1000000; i += 3) {
            factory.set(2 * i);
            Integer put = (Integer)map.putIfAbsent((Object)i, (KeyMap.LazyFactory)factory);
            Assertions.assertThat((Integer)put).isEqualTo(2 * i + 1);
        }
        for (i = 0; i < 1000000; ++i) {
            Assertions.assertThat((Integer)((Integer)map.get((Object)i))).isEqualTo(2 * i + 1);
        }
        Assertions.assertThat((Iterable)map).hasSize(1000000);
        Assertions.assertThat((int)map.traverseAndCountElements()).isEqualTo(1000000);
        Assertions.assertThat((int)map.getCurrentTableCapacity()).isEqualTo(0x200000);
        Assertions.assertThat((int)map.getLongestChainLength()).isLessThanOrEqualTo(7);
    }

    private static class IntegerFactory
    implements KeyMap.LazyFactory<Integer> {
        private Integer toCreate;

        private IntegerFactory() {
        }

        public void set(Integer toCreate) {
            this.toCreate = toCreate;
        }

        public Integer create() {
            return this.toCreate;
        }
    }
}

