/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.time.Duration;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.streaming.api.windowing.triggers.CountTrigger;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeoutTrigger;
import org.apache.flink.streaming.api.windowing.triggers.PurgingTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.TriggerTestHarness;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ProcessingTimeoutTriggerTest {
    ProcessingTimeoutTriggerTest() {
    }

    @Test
    void testWindowFireWithoutResetTimer() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness((Trigger)ProcessingTimeoutTrigger.of((Trigger)CountTrigger.of((long)3L), (Duration)Duration.ofMillis(50L), (boolean)false, (boolean)true), (TypeSerializer)new TimeWindow.Serializer());
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isOne();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        CommonTestUtils.assertThrows((String)"Must have exactly one timer firing. Fired timers: []", IllegalStateException.class, () -> testHarness.advanceProcessingTime(-9223372036854775768L, (Window)new TimeWindow(0L, 2L)));
        Assertions.assertThat((Comparable)testHarness.advanceProcessingTime(-9223372036854775758L, (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.FIRE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.FIRE);
    }

    @Test
    void testWindowFireWithResetTimer() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness((Trigger)ProcessingTimeoutTrigger.of((Trigger)CountTrigger.of((long)3L), (Duration)Duration.ofMillis(50L), (boolean)true, (boolean)true), (TypeSerializer)new TimeWindow.Serializer());
        CommonTestUtils.assertThrows((String)"Must have exactly one timer firing. Fired timers: []", IllegalStateException.class, () -> testHarness.advanceProcessingTime(0L, (Window)new TimeWindow(0L, 2L)));
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        CommonTestUtils.assertThrows((String)"Must have exactly one timer firing. Fired timers: []", IllegalStateException.class, () -> testHarness.advanceProcessingTime(10L, (Window)new TimeWindow(0L, 2L)));
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isOne();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        CommonTestUtils.assertThrows((String)"Must have exactly one timer firing. Fired timers: []", IllegalStateException.class, () -> testHarness.advanceProcessingTime(50L, (Window)new TimeWindow(0L, 2L)));
        Assertions.assertThat((Comparable)testHarness.advanceProcessingTime(60L, (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.FIRE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1, 0L), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1, 10L), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1, 20L), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.FIRE);
    }

    @Test
    void testWindowFireWithoutClearOnTimeout() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness((Trigger)ProcessingTimeoutTrigger.of((Trigger)CountTrigger.of((long)3L), (Duration)Duration.ofMillis(50L), (boolean)false, (boolean)false), (TypeSerializer)new TimeWindow.Serializer());
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isOne();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((Comparable)testHarness.advanceProcessingTime(-9223372036854775758L, (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.FIRE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
    }

    @Test
    void testWindowPurgingWhenInnerTriggerIsPurging() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness((Trigger)ProcessingTimeoutTrigger.of((Trigger)PurgingTrigger.of((Trigger)ProcessingTimeTrigger.create()), (Duration)Duration.ofMillis(50L), (boolean)false, (boolean)false), (TypeSerializer)new TimeWindow.Serializer());
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isOne();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((Comparable)testHarness.advanceProcessingTime(-9223372036854775758L, (Window)new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.FIRE_AND_PURGE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isOne();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isOne();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
    }
}

