/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.retryable;

import org.apache.flink.streaming.util.retryable.AsyncRetryStrategies;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AsyncRetryStrategiesTest {
    AsyncRetryStrategiesTest() {
    }

    @Test
    void testExponentialBackoffDelayRetryStrategy() {
        int maxAttempts = 10;
        long initialDelay = 100L;
        long maxRetryDelay = 2000L;
        double multiplier = 2.0;
        AsyncRetryStrategies.ExponentialBackoffDelayRetryStrategy exponentialBackoffDelayRetryStrategy = new AsyncRetryStrategies.ExponentialBackoffDelayRetryStrategyBuilder(maxAttempts, initialDelay, maxRetryDelay, multiplier).build();
        Assertions.assertThat((boolean)exponentialBackoffDelayRetryStrategy.canRetry(maxAttempts)).isTrue();
        Assertions.assertThat((boolean)exponentialBackoffDelayRetryStrategy.canRetry(maxAttempts + 1)).isFalse();
        for (int j = 1; j <= 5; ++j) {
            long currentDelay = initialDelay;
            for (int i = 1; i <= maxAttempts; ++i) {
                Assertions.assertThat((long)exponentialBackoffDelayRetryStrategy.getBackoffTimeMillis(i)).isEqualTo(currentDelay);
                currentDelay = Math.min((long)((double)currentDelay * multiplier), maxRetryDelay);
            }
        }
    }
}

