/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.source;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.CheckpointListener;
import org.apache.flink.runtime.state.SerializedCheckpointData;
import org.apache.flink.streaming.api.checkpoint.Checkpointed;
import org.apache.flink.streaming.api.functions.source.RichSourceFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public abstract class MessageAcknowledgingSourceBase<Type, UId>
extends RichSourceFunction<Type>
implements Checkpointed<SerializedCheckpointData[]>,
CheckpointListener {
    private static final long serialVersionUID = -8689291992192955579L;
    private static final Logger LOG = LoggerFactory.getLogger(MessageAcknowledgingSourceBase.class);
    private final TypeSerializer<UId> idSerializer;
    private transient List<UId> idsForCurrentCheckpoint;
    private transient ArrayDeque<Tuple2<Long, List<UId>>> pendingCheckpoints;
    private transient Set<UId> idsProcessedButNotAcknowledged;

    protected MessageAcknowledgingSourceBase(Class<UId> idClass) {
        this(TypeExtractor.getForClass(idClass));
    }

    protected MessageAcknowledgingSourceBase(TypeInformation<UId> idTypeInfo) {
        this.idSerializer = idTypeInfo.createSerializer(new ExecutionConfig());
    }

    public void open(Configuration parameters) throws Exception {
        this.idsForCurrentCheckpoint = new ArrayList<UId>(64);
        if (this.pendingCheckpoints == null) {
            this.pendingCheckpoints = new ArrayDeque();
        }
        if (this.idsProcessedButNotAcknowledged == null) {
            this.idsProcessedButNotAcknowledged = new HashSet<UId>();
        }
    }

    public void close() throws Exception {
        this.idsForCurrentCheckpoint.clear();
        this.pendingCheckpoints.clear();
    }

    protected abstract void acknowledgeIDs(long var1, List<UId> var3);

    protected boolean addId(UId uid) {
        this.idsForCurrentCheckpoint.add(uid);
        return this.idsProcessedButNotAcknowledged.add(uid);
    }

    @Override
    public SerializedCheckpointData[] snapshotState(long checkpointId, long checkpointTimestamp) throws Exception {
        LOG.debug("Snapshotting state. Messages: {}, checkpoint id: {}, timestamp: {}", new Object[]{this.idsForCurrentCheckpoint, checkpointId, checkpointTimestamp});
        this.pendingCheckpoints.addLast(new Tuple2((Object)checkpointId, this.idsForCurrentCheckpoint));
        this.idsForCurrentCheckpoint = new ArrayList<UId>(64);
        return SerializedCheckpointData.fromDeque(this.pendingCheckpoints, this.idSerializer);
    }

    @Override
    public void restoreState(SerializedCheckpointData[] state) throws Exception {
        this.idsProcessedButNotAcknowledged = new HashSet<UId>();
        this.pendingCheckpoints = SerializedCheckpointData.toDeque((SerializedCheckpointData[])state, this.idSerializer);
        for (Tuple2<Long, List<UId>> checkpoint : this.pendingCheckpoints) {
            this.idsProcessedButNotAcknowledged.addAll((Collection)checkpoint.f1);
        }
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        LOG.debug("Committing Messages externally for checkpoint {}", (Object)checkpointId);
        Iterator<Tuple2<Long, List<UId>>> iter = this.pendingCheckpoints.iterator();
        while (iter.hasNext()) {
            Tuple2<Long, List<UId>> checkpoint = iter.next();
            long id = (Long)checkpoint.f0;
            if (id > checkpointId) break;
            LOG.trace("Committing Messages with following IDs {}", checkpoint.f1);
            this.acknowledgeIDs(checkpointId, (List)checkpoint.f1);
            this.idsProcessedButNotAcknowledged.removeAll((Collection)checkpoint.f1);
            iter.remove();
        }
    }
}

