/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.windowing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.streaming.api.functions.windowing.AllWindowFunction;
import org.apache.flink.streaming.api.operators.OutputTypeConfigurable;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;

@Internal
public class FoldApplyAllWindowFunction<W extends Window, T, ACC>
extends WrappingFunction<AllWindowFunction<ACC, ACC, W>>
implements AllWindowFunction<T, ACC, W>,
OutputTypeConfigurable<ACC> {
    private static final long serialVersionUID = 1L;
    private final FoldFunction<T, ACC> foldFunction;
    private byte[] serializedInitialValue;
    private TypeSerializer<ACC> accSerializer;
    private transient ACC initialValue;

    public FoldApplyAllWindowFunction(ACC initialValue, FoldFunction<T, ACC> foldFunction, AllWindowFunction<ACC, ACC, W> windowFunction) {
        super(windowFunction);
        this.foldFunction = foldFunction;
        this.initialValue = initialValue;
    }

    public void open(Configuration configuration) throws Exception {
        super.open(configuration);
        if (this.serializedInitialValue == null) {
            throw new RuntimeException("No initial value was serialized for the fold window function. Probably the setOutputType method was not called.");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.serializedInitialValue);
        DataInputViewStreamWrapper in = new DataInputViewStreamWrapper((InputStream)bais);
        this.initialValue = this.accSerializer.deserialize((DataInputView)in);
    }

    @Override
    public void apply(W window, Iterable<T> values, Collector<ACC> out) throws Exception {
        Object result = this.accSerializer.copy(this.initialValue);
        for (T val : values) {
            result = this.foldFunction.fold(result, val);
        }
        ((AllWindowFunction)this.wrappedFunction).apply(window, Collections.singletonList(result), out);
    }

    @Override
    public void setOutputType(TypeInformation<ACC> outTypeInfo, ExecutionConfig executionConfig) {
        this.accSerializer = outTypeInfo.createSerializer(executionConfig);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper((OutputStream)baos);
        try {
            this.accSerializer.serialize(this.initialValue, (DataOutputView)out);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to serialize initial value of type " + this.initialValue.getClass().getSimpleName() + " of fold window function.", ioe);
        }
        this.serializedInitialValue = baos.toByteArray();
    }
}

