/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.io.File;
import java.net.URI;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HDFSCopyToLocal {
    public static void copyToLocal(final URI remotePath, final File localPath) throws Exception {
        String threadName = "HDFS Copy from " + remotePath + " to " + localPath;
        final Tuple1 asyncException = Tuple1.of(null);
        Thread copyThread = new Thread(threadName){

            @Override
            public void run() {
                try {
                    Configuration hadoopConf = HadoopFileSystem.getHadoopConfiguration();
                    FileSystem fs = FileSystem.get((URI)remotePath, (Configuration)hadoopConf);
                    fs.copyToLocalFile(new Path(remotePath), new Path(localPath.getAbsolutePath()));
                }
                catch (Exception t) {
                    asyncException.f0 = t;
                }
            }
        };
        copyThread.setDaemon(true);
        copyThread.start();
        copyThread.join();
        if (asyncException.f0 != null) {
            throw (Exception)asyncException.f0;
        }
    }
}

