/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.testutils;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CommonTestUtils {
    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T createCopySerializable(T original) throws IOException {
        if (original == null) {
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(original);
        oos.close();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            Serializable copy;
            Serializable serializable = copy = (Serializable)ois.readObject();
            return (T)serializable;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public static String createTempFile(String contents) throws IOException {
        File f = File.createTempFile("flink_test_", ".tmp");
        f.deleteOnExit();
        try (BufferedWriter out = new BufferedWriter(new FileWriter(f));){
            out.write(contents);
        }
        return f.toURI().toString();
    }
}

