/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.junit.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class TempDirUtils {
    private static final String TMP_PREFIX = "junit";

    public static File newFolder(Path path) throws IOException {
        Path tempPath = path != null ? Files.createTempDirectory(path, TMP_PREFIX, new FileAttribute[0]) : Files.createTempDirectory(TMP_PREFIX, new FileAttribute[0]);
        return tempPath.toFile();
    }

    public static File newFile(Path path) throws IOException {
        return File.createTempFile(TMP_PREFIX, null, path.toFile());
    }

    public static File newFolder(Path base, String ... paths) throws IOException {
        if (paths.length == 0) {
            throw new IllegalArgumentException("must pass at least one path");
        }
        File root = base.toFile();
        for (String path : paths) {
            if (!new File(path).isAbsolute()) continue;
            throw new IOException(String.format("folder path '%s' is not a relative path", path));
        }
        File relativePath = null;
        File file = root;
        boolean lastMkdirsCallSuccessful = true;
        for (String path : paths) {
            file = new File(root, (relativePath = new File(relativePath, path)).getPath());
            lastMkdirsCallSuccessful = file.mkdirs();
            if (lastMkdirsCallSuccessful || file.isDirectory()) continue;
            if (file.exists()) {
                throw new IOException(String.format("a file with the path '%s' exists", relativePath.getPath()));
            }
            throw new IOException(String.format("could not create a folder with the path: '%s'", relativePath.getPath()));
        }
        if (!lastMkdirsCallSuccessful) {
            throw new IOException(String.format("a folder with the path '%s' already exists", relativePath.getPath()));
        }
        return file;
    }

    public static File newFile(Path folder, String fileName) throws IOException {
        File file = new File(folder.toFile(), fileName);
        if (!file.createNewFile()) {
            throw new IOException(String.format("a file with the name '%s' already exists in the test folder", fileName));
        }
        return file;
    }
}

