/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.packaging;

import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;

public class PackagingTestUtils {
    public static void assertJarContainsOnlyFilesMatching(Path jarPath, Collection<String> allowedPaths) throws Exception {
        URI jar = jarPath.toUri();
        try (FileSystem fileSystem = FileSystems.newFileSystem(new URI("jar:file", jar.getHost(), jar.getPath(), jar.getFragment()), Collections.emptyMap());
             Stream<Path> walk = Files.walk(fileSystem.getPath("/", new String[0]), new FileVisitOption[0]);){
            walk.filter(file -> !Files.isDirectory(file, new LinkOption[0])).map(file -> file.toAbsolutePath().toString()).map(file -> file.startsWith("/") ? file.substring(1) : file).forEach(file -> {
                AbstractCollectionAssert cfr_ignored_0 = (AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)allowedPaths).as("Bad file in JAR: %s", new Object[]{file})).anySatisfy(allowedPath -> {
                    if (allowedPath.endsWith("/")) {
                        Assertions.assertThat((String)file).startsWith((CharSequence)allowedPath);
                    } else {
                        Assertions.assertThat((String)file).isEqualTo(allowedPath);
                    }
                });
            });
        }
    }

    public static void assertJarContainsServiceEntry(Path jarPath, Class<?> service) throws Exception {
        URI jar = jarPath.toUri();
        try (FileSystem fileSystem = FileSystems.newFileSystem(new URI("jar:file", jar.getHost(), jar.getPath(), jar.getFragment()), Collections.emptyMap());){
            Assertions.assertThat((Path)fileSystem.getPath("META-INF", "services", service.getName())).exists();
        }
    }
}

