/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cli.deployer;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.geronimo.cli.BaseCLParser;
import org.apache.geronimo.cli.CLParserException;
import org.apache.geronimo.cli.PrintHelper;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.cli.deployer.CommandMetaData;
import org.apache.geronimo.cli.deployer.ConnectionParams;
import org.apache.geronimo.cli.deployer.DeployCommandMetaData;
import org.apache.geronimo.cli.deployer.DistributeCommandMetaData;
import org.apache.geronimo.cli.deployer.EncryptCommandMetaData;
import org.apache.geronimo.cli.deployer.HelpCommandMetaData;
import org.apache.geronimo.cli.deployer.InstallBundleCommandMetaData;
import org.apache.geronimo.cli.deployer.InstallLibraryCommandMetaData;
import org.apache.geronimo.cli.deployer.InstallPluginCommandMetaData;
import org.apache.geronimo.cli.deployer.ListModulesCommandMetaData;
import org.apache.geronimo.cli.deployer.ListTargetsCommandMetaData;
import org.apache.geronimo.cli.deployer.LoginCommandMetaData;
import org.apache.geronimo.cli.deployer.RedeployCommandMetaData;
import org.apache.geronimo.cli.deployer.RestartCommandMetaData;
import org.apache.geronimo.cli.deployer.SearchPluginsCommandMetaData;
import org.apache.geronimo.cli.deployer.StartCommandMetaData;
import org.apache.geronimo.cli.deployer.StopCommandMetaData;
import org.apache.geronimo.cli.deployer.UndeployCommandMetaData;
import org.apache.geronimo.cli.deployer.UninstallBundleCommandMetaData;
import org.apache.geronimo.cli.deployer.UnlockKeystoreCommandMetaData;

public class DeployerCLParser
extends BaseCLParser
implements ConnectionParams {
    private static final String ARGUMENT_URI_SHORTFORM = "U";
    private static final String ARGUMENT_URI = "uri";
    private static final String ARGUMENT_HOST_SHORTFORM = "host";
    private static final String ARGUMENT_PORT_SHORTFORM = "port";
    private static final String ARGUMENT_PORT = "port";
    private static final String ARGUMENT_DRIVER_SHORTFORM = "d";
    private static final String ARGUMENT_DRIVER = "driver";
    private static final String ARGUMENT_USER_SHORTFORM = "u";
    private static final String ARGUMENT_USER = "user";
    private static final String ARGUMENT_PASSWORD_SHORTFORM = "p";
    private static final String ARGUMENT_PASSWORD = "password";
    private static final String ARGUMENT_SYSERR_SHORTFORM = "s";
    private static final String ARGUMENT_SYSERR = "syserr";
    private static final String ARGUMENT_VERBOSE_SHORTFORM = "v";
    private static final String ARGUMENT_VERBOSE = "verbose";
    private static final String ARGUMENT_OFFLINE_SHORTFORM = "o";
    private static final String ARGUMENT_OFFLINE = "offline";
    private static final String ARGUMENT_SECURE_SHORTFORM = "secure";
    private static final String ARGUMENT_SECURE = "secure";
    private final Collection<CommandMetaData> commandMetaData = new ArrayList<CommandMetaData>();
    private CommandArgs commandArgs;
    private CommandMetaData metaData;

    public DeployerCLParser(OutputStream out) {
        super(out);
        this.commandMetaData.add(LoginCommandMetaData.META_DATA);
        this.commandMetaData.add(DeployCommandMetaData.META_DATA);
        this.commandMetaData.add(DistributeCommandMetaData.META_DATA);
        this.commandMetaData.add(ListModulesCommandMetaData.META_DATA);
        this.commandMetaData.add(ListTargetsCommandMetaData.META_DATA);
        this.commandMetaData.add(RedeployCommandMetaData.META_DATA);
        this.commandMetaData.add(StartCommandMetaData.META_DATA);
        this.commandMetaData.add(StopCommandMetaData.META_DATA);
        this.commandMetaData.add(RestartCommandMetaData.META_DATA);
        this.commandMetaData.add(UndeployCommandMetaData.META_DATA);
        this.commandMetaData.add(SearchPluginsCommandMetaData.META_DATA);
        this.commandMetaData.add(InstallPluginCommandMetaData.META_DATA);
        this.commandMetaData.add(HelpCommandMetaData.META_DATA);
        this.commandMetaData.add(InstallLibraryCommandMetaData.META_DATA);
        this.commandMetaData.add(EncryptCommandMetaData.META_DATA);
        this.commandMetaData.add(UnlockKeystoreCommandMetaData.META_DATA);
        this.commandMetaData.add(InstallBundleCommandMetaData.META_DATA);
        this.commandMetaData.add(UninstallBundleCommandMetaData.META_DATA);
        this.addURI();
        this.addHost();
        this.addPort();
        this.addDriver();
        this.addUser();
        this.addPassword();
        this.addSyserr();
        this.addVerbose();
        this.addOffline();
        this.addSecure();
    }

    public CommandMetaData getCommandMetaData() {
        return this.metaData;
    }

    public CommandArgs getCommandArgs() {
        return this.commandArgs;
    }

    @Override
    public String getURI() {
        return this.commandLine.getOptionValue(ARGUMENT_URI_SHORTFORM);
    }

    @Override
    public String getHost() {
        return this.commandLine.getOptionValue(ARGUMENT_HOST_SHORTFORM);
    }

    @Override
    public Integer getPort() {
        String port = this.commandLine.getOptionValue("port");
        if (null == port) {
            return null;
        }
        return new Integer(port);
    }

    @Override
    public String getDriver() {
        return this.commandLine.getOptionValue(ARGUMENT_DRIVER_SHORTFORM);
    }

    @Override
    public String getUser() {
        return this.commandLine.getOptionValue(ARGUMENT_USER_SHORTFORM);
    }

    @Override
    public String getPassword() {
        return this.commandLine.getOptionValue(ARGUMENT_PASSWORD_SHORTFORM);
    }

    @Override
    public boolean isSyserr() {
        return this.commandLine.hasOption(ARGUMENT_SYSERR_SHORTFORM);
    }

    @Override
    public boolean isVerbose() {
        return this.commandLine.hasOption(ARGUMENT_VERBOSE_SHORTFORM);
    }

    @Override
    public boolean isOffline() {
        return this.commandLine.hasOption(ARGUMENT_OFFLINE_SHORTFORM);
    }

    @Override
    public boolean isSecure() {
        return this.commandLine.hasOption("secure");
    }

    @Override
    public void displayHelp() {
        String[] args = new String[]{};
        if (null != this.commandArgs) {
            args = this.commandArgs.getArgs();
        } else if (null != this.metaData) {
            args = new String[]{this.metaData.getCommandName()};
        }
        this.displayHelp(args);
    }

    @Override
    protected void displayHelp(String[] args) {
        PrintHelper printHelper = new PrintHelper(System.out);
        PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
        out.println();
        if (args.length > 0) {
            CommandMetaData commandLine = this.getCommandMetaData(args[0]);
            if (commandLine != null) {
                out.println("Help for command: " + commandLine.getCommandName());
                out.println("    " + this.hangingIndent(commandLine.getCommandName() + " " + commandLine.getHelpArgumentList(), 4));
                out.println();
                out.print(PrintHelper.reformat(commandLine.getHelpText(), 8, 72));
                out.println();
                return;
            }
            if (args[0].equals("options")) {
                out.println("Help on general options:");
                printHelper.printOptions(out, this.options);
                out.println();
                return;
            }
            if (args[0].equals("all")) {
                out.println();
                out.println("All commands");
                out.println();
                for (CommandMetaData commandLine2 : this.commandMetaData) {
                    out.println("    " + this.hangingIndent(commandLine2.getCommandName() + " " + commandLine2.getHelpArgumentList(), 4));
                    out.print(PrintHelper.reformat(commandLine2.getHelpText(), 8, 72));
                    out.println();
                }
                out.println();
                return;
            }
        }
        out.println("usage: java -jar bin/deployer.jar [general options] command [command options]");
        out.println();
        out.println("The general options are:");
        printHelper.printOptionsNoDesc(out, this.options);
        out.println();
        out.println("The available commands are:");
        this.renderCommandList(out);
        out.println();
        out.println("For more information about a specific command, run");
        out.println("    java -jar bin/deployer.jar help [command name]");
        out.println();
        out.println("For more information about all commands, run");
        out.println("    java -jar bin/deployer.jar help all");
        out.println();
        out.println("For more information about general options, run");
        out.println("    java -jar bin/deployer.jar help options");
        out.println();
    }

    private void renderCommandList(PrintWriter out) {
        HashMap<String, ArrayList<String>> temp = new HashMap<String, ArrayList<String>>();
        for (CommandMetaData commandLine : this.commandMetaData) {
            ArrayList<String> list = (ArrayList<String>)temp.get(commandLine.getCommandGroup());
            if (list == null) {
                list = new ArrayList<String>();
                temp.put(commandLine.getCommandGroup(), list);
            }
            list.add(commandLine.getCommandName());
        }
        ArrayList groups = new ArrayList(temp.keySet());
        Collections.sort(groups);
        for (int i = 0; i < groups.size(); ++i) {
            String name = (String)groups.get(i);
            out.println("    " + name);
            List list = (List)temp.get(name);
            Collections.sort(list);
            for (int j = 0; j < list.size(); ++j) {
                String cmd = (String)list.get(j);
                out.println("        " + cmd);
            }
        }
    }

    protected CommandMetaData getCommandMetaData(String commandName) {
        for (CommandMetaData commandLine : this.commandMetaData) {
            if (!commandLine.getCommandName().equals(commandName)) continue;
            return commandLine;
        }
        return null;
    }

    protected String hangingIndent(String source, int cols) {
        String s = PrintHelper.reformat(source, cols, 72);
        return s.substring(cols);
    }

    @Override
    protected void validateOptions() throws CLParserException {
        try {
            this.getPort();
        }
        catch (NumberFormatException e) {
            throw new CLParserException("Port [" + this.commandLine.getOptionValue("port") + "] is not an integer.", e);
        }
    }

    @Override
    protected void validateRemainingArgs() throws CLParserException {
        String[] args = this.commandLine.getArgs();
        if (0 == args.length) {
            throw new CLParserException("No command has been provided.");
        }
        String command = args[0];
        this.metaData = this.getCommandMetaData(command);
        if (null == this.metaData) {
            throw new CLParserException("Command [" + command + "] is undefined.");
        }
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        this.commandArgs = this.metaData.parse(newArgs);
    }

    protected void addOffline() {
        this.options.addOption(ARGUMENT_OFFLINE_SHORTFORM, ARGUMENT_OFFLINE, false, "Deploy offline to a local server, using whatever deployers are available in the local server");
    }

    protected void addSecure() {
        this.options.addOption("secure", "secure", false, "Use secure channel to communicate with the server.  Unsecured channel is used by default.");
    }

    protected void addVerbose() {
        this.options.addOption(ARGUMENT_VERBOSE_SHORTFORM, ARGUMENT_VERBOSE, false, "Enables verbose execution mode.  Disabled by default.");
    }

    protected void addSyserr() {
        this.options.addOption(ARGUMENT_SYSERR_SHORTFORM, ARGUMENT_SYSERR, false, "Enables error logging to syserr.  Disabled by default.");
    }

    protected void addPassword() {
        this.addOptionWithParam(ARGUMENT_PASSWORD, ARGUMENT_PASSWORD_SHORTFORM, ARGUMENT_PASSWORD, "Specifies a password to use to authenticate to the server.");
    }

    protected void addUser() {
        this.addOptionWithParam(ARGUMENT_USER, ARGUMENT_USER_SHORTFORM, "username", "If the deployment operation requires authentication, then you can specify the username to use to connect.  If no password is specified, the deployer will attempt to connect to the server with no password, and if that fails, will prompt you for a password.");
    }

    protected void addDriver() {
        this.addOptionWithParam(ARGUMENT_DRIVER, ARGUMENT_DRIVER_SHORTFORM, "driver.jar", "If you want to use this tool with a server other than Geronimo, then you must provide the path to its driver JAR.  Currently, manifest Class-Path entries in that JAR are ignored.");
    }

    protected void addPort() {
        this.addOptionWithParam("port", "port", "port", "The RMI listen port of a Geronimo server to deploy to.  This option is not compatible with --uri, but is often used with --host.  The default port is 1099.");
    }

    protected void addHost() {
        this.addOptionWithParam(ARGUMENT_HOST_SHORTFORM, ARGUMENT_HOST_SHORTFORM, "hostname", "The host name of a Geronimo server to deploy to.  This option is not compatible with --uri, but is often used with --port.");
    }

    protected void addURI() {
        this.addOptionWithParam(ARGUMENT_URI, ARGUMENT_URI_SHORTFORM, ARGUMENT_URI, "A URI to contact the server.  If not specified, the deployer defaults to operating on a Geronimo server running on the standard port on localhost.\nA URI to connect to Geronimo (including optional host and port parameters) has the form: deployer:geronimo:jmx[://host[:port]] (though you could also just use --host and --port instead).");
    }
}

