/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cli.deployer;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.geronimo.cli.CLParserException;
import org.apache.geronimo.cli.deployer.DistributeCommandArgs;

public class DistributeCommandArgsImpl
implements DistributeCommandArgs {
    private static final String ARGUMENT_IN_PLACE_SHORTFORM = "i";
    private static final String ARGUMENT_IN_PLACE = "inPlace";
    private static final String ARGUMENT_TARGETS_SHORTFORM = "t";
    private static final String ARGUMENT_TARGETS = "targets";
    protected final Options options = new Options();
    protected CommandLine commandLine;

    public DistributeCommandArgsImpl(String[] args) throws CLParserException {
        this.addInPlace();
        this.addTargets();
        GnuParser parser = new GnuParser();
        try {
            this.commandLine = parser.parse(this.options, args, true);
        }
        catch (ParseException e) {
            throw new CLParserException(e.getMessage(), e);
        }
        if (0 == this.commandLine.getArgs().length) {
            throw new CLParserException("Must specify a module or plan (or both)");
        }
        if (2 < this.commandLine.getArgs().length) {
            throw new CLParserException("Too many arguments");
        }
    }

    protected void addTargets() {
        OptionBuilder.hasArg();
        OptionBuilder optionBuilder = OptionBuilder.withArgName((String)ARGUMENT_TARGETS);
        optionBuilder = OptionBuilder.withLongOpt((String)ARGUMENT_TARGETS);
        optionBuilder = OptionBuilder.withDescription((String)"If no targets are provided, the module is distributed to all available targets. Geronimo only provides one target (ever), so this is primarily useful when using a different driver.\n");
        Option option = OptionBuilder.create((String)ARGUMENT_TARGETS_SHORTFORM);
        this.options.addOption(option);
    }

    protected void addInPlace() {
        this.options.addOption(ARGUMENT_IN_PLACE_SHORTFORM, ARGUMENT_IN_PLACE, false, "If inPlace is provided, the module is not copied to the configuration store of the selected targets. The targets directly use the module.");
    }

    @Override
    public String[] getTargets() {
        String targets = this.commandLine.getOptionValue(ARGUMENT_TARGETS_SHORTFORM);
        if (null == targets) {
            return new String[0];
        }
        return targets.split(";");
    }

    @Override
    public boolean isInPlace() {
        return this.commandLine.hasOption(ARGUMENT_IN_PLACE_SHORTFORM);
    }

    @Override
    public String[] getArgs() {
        return this.commandLine.getArgs();
    }
}

