/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DataSourceDriver
implements Driver {
    private static final String BASE = "jdbc:geronimo:datasource:";

    public Connection connect(String url, Properties info) throws SQLException {
        DataSource ds;
        if (url == null || !url.startsWith(BASE)) {
            return null;
        }
        String name = url.substring(BASE.length());
        try {
            InitialContext ctx = new InitialContext();
            try {
                ds = (DataSource)ctx.lookup("java:comp/env/" + name);
            }
            catch (NameNotFoundException e) {
                ds = (DataSource)ctx.lookup(name);
            }
        }
        catch (NamingException e) {
            throw (SQLException)new SQLException("Could not look up datasource").initCause(e);
        }
        return ds.getConnection();
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url != null && url.startsWith(BASE);
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    static {
        try {
            DriverManager.registerDriver(new DataSourceDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

