/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.basic;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.reflect.FastClass;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.gbean.GOperationSignature;
import org.apache.geronimo.gbean.runtime.RawInvoker;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.basic.KernelGetAttributeInvoker;
import org.apache.geronimo.kernel.basic.KernelOperationInvoker;
import org.apache.geronimo.kernel.basic.KernelSetAttributeInvoker;
import org.apache.geronimo.kernel.basic.ProxyInvoker;
import org.apache.geronimo.kernel.basic.RawGetAttributeInvoker;
import org.apache.geronimo.kernel.basic.RawOperationInvoker;
import org.apache.geronimo.kernel.basic.RawSetAttributeInvoker;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.kernel.proxy.DeadProxyException;
import org.apache.geronimo.kernel.proxy.GeronimoManagedBean;

public class ProxyMethodInterceptor
implements MethodInterceptor {
    private final Class proxyType;
    private final AbstractName abstractName;
    private ProxyInvoker[] gbeanInvokers;

    public ProxyMethodInterceptor(Class proxyType, Kernel kernel, AbstractName abstractName) {
        assert (proxyType != null);
        assert (kernel != null);
        assert (abstractName != null);
        this.proxyType = proxyType;
        this.abstractName = abstractName;
        this.gbeanInvokers = this.createGBeanInvokers(kernel, abstractName);
    }

    public synchronized void destroy() {
        this.gbeanInvokers = null;
    }

    public AbstractName getAbstractName() {
        return this.abstractName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object intercept(Object object, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        ProxyInvoker gbeanInvoker;
        int interfaceIndex = proxy.getSuperIndex();
        ProxyMethodInterceptor proxyMethodInterceptor = this;
        synchronized (proxyMethodInterceptor) {
            if (this.gbeanInvokers == null) {
                throw new DeadProxyException("Proxy is no longer valid to gbean: " + this.abstractName);
            }
            gbeanInvoker = this.gbeanInvokers[interfaceIndex];
        }
        if (gbeanInvoker == null) {
            throw new UnsupportedOperationException("No implementation method: abstractName=" + this.abstractName + ", method=" + method);
        }
        return gbeanInvoker.invoke(this.abstractName, args);
    }

    private ProxyInvoker[] createGBeanInvokers(Kernel kernel, AbstractName abstractName) {
        ProxyInvoker[] invokers;
        try {
            RawInvoker rawInvoker = (RawInvoker)kernel.getAttribute(abstractName, "$$RAW_INVOKER$$");
            invokers = this.createRawGBeanInvokers(rawInvoker, this.proxyType);
        }
        catch (Exception e) {
            invokers = this.createKernelGBeanInvokers(kernel, abstractName, this.proxyType);
        }
        try {
            invokers[ProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"equals", new Class[]{Object.class}))] = new EqualsInvoke(kernel);
            invokers[ProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"hashCode", (Class[])null))] = new HashCodeInvoke();
            invokers[ProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"toString", (Class[])null))] = new ToStringInvoke(this.proxyType.getName());
            if (GeronimoManagedBean.class.isAssignableFrom(this.proxyType)) {
                invokers[ProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"getState", (Class[])null))] = new GetStateInvoke(kernel);
                invokers[ProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"getStateInstance", (Class[])null))] = new GetStateInstanceInvoke(kernel);
                invokers[ProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"start", (Class[])null))] = new StartInvoke(kernel);
                invokers[ProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"startRecursive", (Class[])null))] = new StartRecursiveInvoke(kernel);
                invokers[ProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"stop", (Class[])null))] = new StopInvoke(kernel);
                invokers[ProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"getStartTime", (Class[])null))] = new GetStartTimeInvoke(kernel);
                invokers[ProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"getObjectName", (Class[])null))] = new GetObjectNameInvoke(kernel);
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)new Exception("Could not install invoker for proxyType " + this.proxyType + " for target " + abstractName, e));
        }
        return invokers;
    }

    private ProxyInvoker[] createRawGBeanInvokers(RawInvoker rawInvoker, Class proxyType) {
        Map operations = rawInvoker.getOperationIndex();
        Map attributes = rawInvoker.getAttributeIndex();
        FastClass fastClass = FastClass.create((Class)proxyType);
        ProxyInvoker[] invokers = new ProxyInvoker[fastClass.getMaxIndex() + 1];
        Method[] methods = proxyType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            int interfaceIndex = ProxyMethodInterceptor.getSuperIndex(proxyType, method);
            if (interfaceIndex < 0) continue;
            invokers[interfaceIndex] = this.createRawGBeanInvoker(rawInvoker, method, operations, attributes);
        }
        return invokers;
    }

    private ProxyInvoker createRawGBeanInvoker(RawInvoker rawInvoker, Method method, Map operations, Map attributes) {
        Integer methodIndex;
        String attributeName;
        if (operations.containsKey(new GOperationSignature(method))) {
            int methodIndex2 = (Integer)operations.get(new GOperationSignature(method));
            return new RawOperationInvoker(rawInvoker, methodIndex2);
        }
        if (method.getName().startsWith("get")) {
            attributeName = method.getName().substring(3);
            methodIndex = (Integer)attributes.get(attributeName);
            if (methodIndex != null) {
                return new RawGetAttributeInvoker(rawInvoker, methodIndex);
            }
            methodIndex = ProxyMethodInterceptor.getMethodIndex(attributes, attributeName);
            if (methodIndex != null) {
                return new RawGetAttributeInvoker(rawInvoker, methodIndex);
            }
        }
        if (method.getName().startsWith("is")) {
            attributeName = method.getName().substring(2);
            methodIndex = (Integer)attributes.get(attributeName);
            if (methodIndex != null) {
                return new RawGetAttributeInvoker(rawInvoker, methodIndex);
            }
            methodIndex = ProxyMethodInterceptor.getMethodIndex(attributes, attributeName);
            if (methodIndex != null) {
                return new RawGetAttributeInvoker(rawInvoker, methodIndex);
            }
        }
        if (method.getName().startsWith("set")) {
            attributeName = method.getName().substring(3);
            methodIndex = (Integer)attributes.get(attributeName);
            if (methodIndex != null) {
                return new RawSetAttributeInvoker(rawInvoker, methodIndex);
            }
            methodIndex = ProxyMethodInterceptor.getMethodIndex(attributes, attributeName);
            if (methodIndex != null) {
                return new RawSetAttributeInvoker(rawInvoker, methodIndex);
            }
        }
        return null;
    }

    private ProxyInvoker[] createKernelGBeanInvokers(Kernel kernel, AbstractName abstractName, Class proxyType) {
        GBeanInfo info;
        try {
            info = kernel.getGBeanInfo(abstractName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not get GBeanInfo for target object: " + abstractName, e);
        }
        Set<GAttributeInfo> attributeInfos = info.getAttributes();
        HashSet<String> attributeNames = new HashSet<String>(attributeInfos.size());
        for (GAttributeInfo attributeInfo : attributeInfos) {
            attributeNames.add(attributeInfo.getName());
        }
        Set<GOperationInfo> operationInfos = info.getOperations();
        HashSet<GOperationSignature> operationSignatures = new HashSet<GOperationSignature>(operationInfos.size());
        for (GOperationInfo operationInfo : operationInfos) {
            operationSignatures.add(new GOperationSignature(operationInfo.getName(), operationInfo.getParameterList()));
        }
        FastClass fastClass = FastClass.create((Class)proxyType);
        ProxyInvoker[] invokers = new ProxyInvoker[fastClass.getMaxIndex() + 1];
        Method[] methods = proxyType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            int interfaceIndex = ProxyMethodInterceptor.getSuperIndex(proxyType, method);
            if (interfaceIndex < 0) continue;
            invokers[interfaceIndex] = this.createJMXGBeanInvoker(kernel, method, operationSignatures, attributeNames);
        }
        return invokers;
    }

    private ProxyInvoker createJMXGBeanInvoker(Kernel kernel, Method method, Set operationSignatures, Set attributeNames) {
        if (operationSignatures.contains(new GOperationSignature(method))) {
            return new KernelOperationInvoker(kernel, method);
        }
        String name = method.getName();
        if (name.startsWith("get")) {
            String attributeName = method.getName().substring(3);
            if (attributeNames.contains(attributeName)) {
                return new KernelGetAttributeInvoker(kernel, attributeName);
            }
            if (attributeNames.contains(attributeName = Introspector.decapitalize(attributeName))) {
                return new KernelGetAttributeInvoker(kernel, attributeName);
            }
        } else if (name.startsWith("is")) {
            String attrName = method.getName().substring(2);
            if (attributeNames.contains(attrName)) {
                return new KernelGetAttributeInvoker(kernel, attrName);
            }
            if (attributeNames.contains(attrName = Introspector.decapitalize(attrName))) {
                return new KernelGetAttributeInvoker(kernel, attrName);
            }
        } else if (name.startsWith("set")) {
            String attrName = method.getName().substring(3);
            if (attributeNames.contains(attrName)) {
                return new KernelSetAttributeInvoker(kernel, attrName);
            }
            if (attributeNames.contains(attrName = Introspector.decapitalize(attrName))) {
                return new KernelSetAttributeInvoker(kernel, attrName);
            }
        }
        return null;
    }

    private static int getSuperIndex(Class proxyType, Method method) {
        Signature signature = new Signature(method.getName(), Type.getReturnType((Method)method), Type.getArgumentTypes((Method)method));
        MethodProxy methodProxy = MethodProxy.find((Class)proxyType, (Signature)signature);
        if (methodProxy != null) {
            return methodProxy.getSuperIndex();
        }
        return -1;
    }

    private static Integer getMethodIndex(Map attributes, String attributeName) {
        for (String key : attributes.keySet()) {
            if (!key.equalsIgnoreCase(attributeName)) continue;
            return (Integer)attributes.get(key);
        }
        return null;
    }

    static final class GetObjectNameInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public GetObjectNameInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            GBeanData gBeanData = this.kernel.getGBeanData(abstractName);
            return gBeanData.getAbstractName().getObjectName().getCanonicalName();
        }
    }

    static final class StopInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public StopInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            this.kernel.stopGBean(abstractName);
            return null;
        }
    }

    static final class GetStartTimeInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public GetStartTimeInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            return new Long(this.kernel.getGBeanStartTime(abstractName));
        }
    }

    static final class StartRecursiveInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public StartRecursiveInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            this.kernel.startRecursiveGBean(abstractName);
            return null;
        }
    }

    static final class StartInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public StartInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            this.kernel.startGBean(abstractName);
            return null;
        }
    }

    static final class GetStateInstanceInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public GetStateInstanceInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            return State.fromInt(this.kernel.getGBeanState(abstractName));
        }
    }

    static final class GetStateInvoke
    implements ProxyInvoker {
        private Kernel kernel;

        public GetStateInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            return new Integer(this.kernel.getGBeanState(abstractName));
        }
    }

    static final class ToStringInvoke
    implements ProxyInvoker {
        private final String interfaceName;

        public ToStringInvoke(String interfaceName) {
            this.interfaceName = "[" + interfaceName + ": ";
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            return this.interfaceName + abstractName + "]";
        }
    }

    static final class EqualsInvoke
    implements ProxyInvoker {
        private final Kernel kernel;

        public EqualsInvoke(Kernel kernel) {
            this.kernel = kernel;
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            AbstractName proxyTarget = this.kernel.getAbstractNameFor(arguments[0]);
            return abstractName.equals(proxyTarget);
        }
    }

    static final class HashCodeInvoke
    implements ProxyInvoker {
        HashCodeInvoke() {
        }

        @Override
        public Object invoke(AbstractName abstractName, Object[] arguments) throws Throwable {
            return new Integer(abstractName.hashCode());
        }
    }
}

