/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationInfo;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModel;
import org.apache.geronimo.kernel.config.ConfigurationResolver;
import org.apache.geronimo.kernel.config.ConfigurationSource;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.DependencyNode;
import org.apache.geronimo.kernel.config.DependencyNodeUtil;
import org.apache.geronimo.kernel.config.DeploymentWatcher;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.LifecycleException;
import org.apache.geronimo.kernel.config.LifecycleMonitor;
import org.apache.geronimo.kernel.config.LifecycleResults;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.config.NoSuchStoreException;
import org.apache.geronimo.kernel.config.NullLifecycleMonitor;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.kernel.repository.Version;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="ConfigurationManager")
public class SimpleConfigurationManager
implements ConfigurationManager {
    protected static final Logger log = LoggerFactory.getLogger(SimpleConfigurationManager.class);
    protected final Collection<ConfigurationStore> stores;
    private final ArtifactResolver artifactResolver;
    protected final Map<Artifact, Configuration> configurations = new LinkedHashMap<Artifact, Configuration>();
    protected final Map<Artifact, Bundle> bundles = new LinkedHashMap<Artifact, Bundle>();
    protected final ConfigurationModel configurationModel;
    protected final Collection<? extends Repository> repositories;
    protected final Collection<DeploymentWatcher> watchers;
    protected final BundleContext bundleContext;
    private final ThreadLocal<Map<Artifact, Configuration>> loadedConfigurations = new ThreadLocal<Map<Artifact, Configuration>>(){};
    private Configuration reloadingConfiguration;
    private Object reloadingConfigurationLock = new Object();

    public SimpleConfigurationManager(Collection<ConfigurationStore> stores, ArtifactResolver artifactResolver, Collection<? extends Repository> repositories, BundleContext bundleContext) {
        this(stores, artifactResolver, repositories, Collections.emptySet(), bundleContext);
    }

    public SimpleConfigurationManager(@ParamReference(name="Stores", namingType="ConfigurationStore") Collection<ConfigurationStore> stores, @ParamReference(name="ArtifactResolver", namingType="ArtifactResolver") ArtifactResolver artifactResolver, @ParamReference(name="Repositories", namingType="Repository") Collection<? extends Repository> repositories, @ParamReference(name="Watchers") Collection<DeploymentWatcher> watchers, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext) {
        this(stores, artifactResolver, repositories, watchers, bundleContext, new ConfigurationModel());
    }

    public SimpleConfigurationManager(Collection<ConfigurationStore> stores, ArtifactResolver artifactResolver, Collection<? extends Repository> repositories, Collection<DeploymentWatcher> watchers, BundleContext bundleContext, ConfigurationModel configurationModel) {
        if (stores == null) {
            stores = Collections.emptySet();
        }
        if (repositories == null) {
            repositories = Collections.emptySet();
        }
        for (Repository repository : repositories) {
            if (repository != null) continue;
            throw new NullPointerException("null repository");
        }
        if (watchers == null) {
            watchers = Collections.emptySet();
        }
        for (DeploymentWatcher deploymentWatcher : watchers) {
            if (deploymentWatcher != null) continue;
            throw new NullPointerException("null DeploymentWatcher");
        }
        this.configurationModel = configurationModel;
        this.stores = stores;
        this.artifactResolver = artifactResolver;
        this.repositories = repositories;
        this.watchers = watchers;
        this.bundleContext = bundleContext;
    }

    public ConfigurationModel getConfigurationModel() {
        return this.configurationModel;
    }

    @Override
    public synchronized boolean isInstalled(Artifact configId) {
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        for (ConfigurationStore store : this.getStoreList()) {
            if (!store.containsConfiguration(configId)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLoaded(Artifact configId) {
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        Object object = this.reloadingConfigurationLock;
        synchronized (object) {
            if (this.reloadingConfiguration != null && this.reloadingConfiguration.getId().equals(configId)) {
                return true;
            }
        }
        object = this;
        synchronized (object) {
            return this.configurationModel.isLoaded(configId);
        }
    }

    @Override
    public synchronized boolean isRunning(Artifact configId) {
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        return this.configurationModel.isStarted(configId);
    }

    @Override
    public Artifact[] getInstalled(Artifact query) {
        Artifact[] all = this.artifactResolver.queryArtifacts(query);
        ArrayList<Artifact> configs = new ArrayList<Artifact>();
        for (Artifact artifact : all) {
            if (!this.isConfiguration(artifact)) continue;
            configs.add(artifact);
        }
        if (configs.size() == all.length) {
            return all;
        }
        return configs.toArray(new Artifact[configs.size()]);
    }

    @Override
    public Artifact[] getLoaded(Artifact query) {
        return this.configurationModel.getLoaded(query);
    }

    @Override
    public Artifact[] getRunning(Artifact query) {
        return this.configurationModel.getStarted(query);
    }

    @Override
    public List<AbstractName> listStores() {
        List<ConfigurationStore> storeSnapshot = this.getStoreList();
        ArrayList<AbstractName> result = new ArrayList<AbstractName>(storeSnapshot.size());
        for (ConfigurationStore store : storeSnapshot) {
            result.add(store.getAbstractName());
        }
        return result;
    }

    @Override
    public ConfigurationStore[] getStores() {
        List<ConfigurationStore> storeSnapshot = this.getStoreList();
        return storeSnapshot.toArray(new ConfigurationStore[storeSnapshot.size()]);
    }

    @Override
    public Collection<? extends Repository> getRepositories() {
        return this.repositories;
    }

    @Override
    public List listConfigurations() {
        List<ConfigurationStore> storeSnapshot = this.getStoreList();
        ArrayList<ConfigurationInfo> list = new ArrayList<ConfigurationInfo>();
        for (ConfigurationStore store : storeSnapshot) {
            list.addAll(this.listConfigurations(store));
        }
        return list;
    }

    @Override
    public ConfigurationStore getStoreForConfiguration(Artifact configId) {
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        List<ConfigurationStore> storeSnapshot = this.getStoreList();
        for (ConfigurationStore store : storeSnapshot) {
            if (!store.containsConfiguration(configId)) continue;
            return store;
        }
        return null;
    }

    @Override
    public List<ConfigurationInfo> listConfigurations(AbstractName storeName) throws NoSuchStoreException {
        for (ConfigurationStore store : this.getStoreList()) {
            if (!storeName.equals(store.getAbstractName())) continue;
            return this.listConfigurations(store);
        }
        throw new NoSuchStoreException("No such store: " + storeName);
    }

    private List<ConfigurationInfo> listConfigurations(ConfigurationStore store) {
        List<ConfigurationInfo> list = store.listConfigurations();
        ListIterator<ConfigurationInfo> iterator = list.listIterator();
        while (iterator.hasNext()) {
            ConfigurationInfo configurationInfo = iterator.next();
            configurationInfo = this.isRunning(configurationInfo.getConfigID()) ? new ConfigurationInfo(store.getAbstractName(), configurationInfo.getConfigID(), configurationInfo.getType(), configurationInfo.getCreated(), configurationInfo.getOwnedConfigurations(), configurationInfo.getChildConfigurations(), configurationInfo.getInPlaceLocation(), State.RUNNING) : new ConfigurationInfo(store.getAbstractName(), configurationInfo.getConfigID(), configurationInfo.getType(), configurationInfo.getCreated(), configurationInfo.getOwnedConfigurations(), configurationInfo.getChildConfigurations(), configurationInfo.getInPlaceLocation(), State.STOPPED);
            iterator.set(configurationInfo);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConfiguration(Artifact artifact) {
        if (!artifact.isResolved()) {
            throw new IllegalArgumentException("Artifact " + artifact + " is not fully resolved");
        }
        Map<Artifact, Configuration> map = this.configurations;
        synchronized (map) {
            if (this.configurations.containsKey(artifact)) {
                return true;
            }
        }
        for (ConfigurationStore store : this.getStoreList()) {
            if (!store.containsConfiguration(artifact)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration getConfiguration(Artifact configurationId) {
        if (!configurationId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configurationId + " is not fully resolved");
        }
        Map<Artifact, Configuration> map = this.reloadingConfigurationLock;
        synchronized (map) {
            if (this.reloadingConfiguration != null && this.reloadingConfiguration.getId().equals(configurationId)) {
                return this.reloadingConfiguration;
            }
        }
        map = this.configurations;
        synchronized (map) {
            return this.configurations.get(configurationId);
        }
    }

    @Override
    public Bundle getBundle(Artifact id) {
        if (!id.isResolved()) {
            throw new IllegalArgumentException("Artifact " + id + " is not fully resolved");
        }
        return this.bundles.get(id);
    }

    @Override
    public synchronized LifecycleResults loadConfiguration(Artifact configurationId) throws NoSuchConfigException, LifecycleException {
        return this.loadConfiguration(configurationId, (LifecycleMonitor)NullLifecycleMonitor.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized LifecycleResults loadConfiguration(Artifact configurationId, LifecycleMonitor monitor) throws NoSuchConfigException, LifecycleException {
        if (!configurationId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configurationId + " is not fully resolved");
        }
        if (this.isLoaded(configurationId)) {
            this.load(configurationId);
            monitor.finished();
            return new LifecycleResults();
        }
        try {
            String location = this.locateBundle(configurationId, monitor);
            Bundle bundle = this.bundleContext.installBundle(location);
            if (BundleUtils.canStart((Bundle)bundle)) {
                bundle.start(1);
            }
            this.bundles.put(configurationId, bundle);
        }
        catch (Exception e) {
            monitor.finished();
            throw new LifecycleException("load", configurationId, e);
        }
        LifecycleResults results = new LifecycleResults();
        Map<Artifact, Configuration> map = this.configurations;
        synchronized (map) {
            if (!this.configurations.containsKey(configurationId)) {
                this.configurationModel.addConfiguration(configurationId, Collections.<Artifact>emptySet(), Collections.<Artifact>emptySet());
            }
        }
        this.load(configurationId);
        return results;
    }

    @Override
    public synchronized LifecycleResults loadConfiguration(ConfigurationData configurationData) throws NoSuchConfigException, LifecycleException {
        return this.loadConfiguration(configurationData, (LifecycleMonitor)NullLifecycleMonitor.INSTANCE);
    }

    @Override
    public synchronized LifecycleResults loadConfiguration(ConfigurationData configurationData, LifecycleMonitor monitor) throws NoSuchConfigException, LifecycleException {
        Artifact id = configurationData.getId();
        LifecycleResults results = new LifecycleResults();
        if (!this.isLoaded(id)) {
            boolean newLoad;
            LinkedHashSet<Artifact> resolvedParents;
            try {
                resolvedParents = this.resolveParentIds(configurationData);
            }
            catch (Exception e) {
                monitor.finished();
                throw new LifecycleException("load", id, e);
            }
            Map<Artifact, Configuration> actuallyLoaded = this.loadedConfigurations.get();
            boolean bl = newLoad = actuallyLoaded == null;
            if (actuallyLoaded == null) {
                actuallyLoaded = new LinkedHashMap<Artifact, Configuration>(resolvedParents.size());
                this.loadedConfigurations.set(actuallyLoaded);
            }
            try {
                Configuration configuration = this.load(configurationData, resolvedParents, actuallyLoaded);
                actuallyLoaded.put(configurationData.getId(), configuration);
                this.addNewConfigurationToModel(configuration);
            }
            catch (Exception e) {
                monitor.finished();
                throw new LifecycleException("load", id, e);
            }
            finally {
                if (newLoad) {
                    this.loadedConfigurations.remove();
                }
            }
        }
        this.load(id);
        monitor.finished();
        return results;
    }

    protected void load(Artifact configurationId) throws NoSuchConfigException {
        this.configurationModel.load(configurationId);
    }

    protected Configuration load(ConfigurationData configurationData, LinkedHashSet<Artifact> resolvedParentIds, Map<Artifact, Configuration> loadedConfigurations) throws InvalidConfigException {
        try {
            ConfigurationResolver configurationResolver = this.newConfigurationResolver(configurationData);
            return this.doLoad(configurationData, resolvedParentIds, loadedConfigurations, configurationResolver);
        }
        catch (Exception e) {
            throw new InvalidConfigException("Error starting configuration gbean " + configurationData.getId(), e);
        }
    }

    @Override
    public ConfigurationResolver newConfigurationResolver(ConfigurationData configurationData) {
        ConfigurationResolver configurationResolver = new ConfigurationResolver(configurationData, this.repositories, this.artifactResolver);
        return configurationResolver;
    }

    protected Configuration doLoad(ConfigurationData configurationData, LinkedHashSet<Artifact> resolvedParentIds, Map<Artifact, Configuration> loadedConfigurations, ConfigurationResolver configurationResolver) throws Exception {
        DependencyNode dependencyNode = this.buildDependencyNode(configurationData);
        List<Configuration> allServiceParents = this.buildAllServiceParents(loadedConfigurations, dependencyNode);
        Configuration configuration = new Configuration(configurationData, dependencyNode, allServiceParents, null, configurationResolver, this);
        configuration.doStart();
        resolvedParentIds.add(configuration.getId());
        Map<Artifact, Configuration> moreLoadedConfigurations = loadedConfigurations;
        moreLoadedConfigurations.put(dependencyNode.getId(), configuration);
        for (Map.Entry<String, ConfigurationData> childEntry : configurationData.getChildConfigurations().entrySet()) {
            ConfigurationResolver childResolver = configurationResolver.createChildResolver(childEntry.getKey());
            Configuration child = this.doLoad(childEntry.getValue(), resolvedParentIds, moreLoadedConfigurations, childResolver);
            configuration.addChild(child);
        }
        return configuration;
    }

    protected List<Configuration> buildAllServiceParents(Map<Artifact, Configuration> loadedConfigurations, DependencyNode dependencyNode) throws InvalidConfigException {
        ArrayList<Configuration> allServiceParents = new ArrayList<Configuration>();
        for (Artifact parentId : dependencyNode.getServiceParents()) {
            this.addDepthFirstServiceParents(parentId, allServiceParents, new HashSet<Artifact>(), loadedConfigurations);
        }
        return allServiceParents;
    }

    protected DependencyNode buildDependencyNode(ConfigurationData configurationData) throws MissingDependencyException {
        DependencyNode dependencyNode = DependencyNodeUtil.toDependencyNode(configurationData.getEnvironment(), this.artifactResolver, this);
        return dependencyNode;
    }

    private void addDepthFirstServiceParents(Artifact id, List<Configuration> ancestors, Set<Artifact> ids, Map<Artifact, Configuration> loadedConfigurations) throws InvalidConfigException {
        if (!ids.contains(id)) {
            Configuration configuration = this.getConfiguration(id, loadedConfigurations);
            ancestors.add(configuration);
            ids.add(id);
            for (Artifact parentId : configuration.getDependencyNode().getServiceParents()) {
                this.addDepthFirstServiceParents(parentId, ancestors, ids, loadedConfigurations);
            }
        }
    }

    private Configuration getConfiguration(Artifact resolvedArtifact, Map<Artifact, Configuration> loadedConfigurations) throws InvalidConfigException {
        Configuration parent;
        if (loadedConfigurations.containsKey(resolvedArtifact)) {
            parent = loadedConfigurations.get(resolvedArtifact);
        } else if (this.isLoaded(resolvedArtifact)) {
            parent = this.getConfiguration(resolvedArtifact);
        } else {
            throw new InvalidConfigException("Cound not find parent configuration: " + resolvedArtifact);
        }
        return parent;
    }

    protected void addNewConfigurationToModel(Configuration configuration) throws NoSuchConfigException {
        this.configurationModel.addConfiguration(configuration.getId(), SimpleConfigurationManager.getConfigurationIds(this.getLoadParents(configuration)), SimpleConfigurationManager.getConfigurationIds(this.getStartParents(configuration)));
        this.configurations.put(configuration.getId(), configuration);
    }

    protected LinkedHashSet<Configuration> getLoadParents(Configuration configuration) throws NoSuchConfigException {
        LinkedHashSet<Configuration> loadParent = new LinkedHashSet<Configuration>();
        this.getLoadParentsInternal(configuration, loadParent, this);
        return loadParent;
    }

    private void getLoadParentsInternal(final Configuration configuration, LinkedHashSet<Configuration> parents, final ConfigurationSource configurationSource) throws NoSuchConfigException {
        DependencyNodeUtil.addClassParents(configuration.getDependencyNode(), parents, configurationSource);
        for (Configuration childConfiguration : configuration.getChildren()) {
            ConfigurationSource childSource = new ConfigurationSource(){

                @Override
                public Configuration getConfiguration(Artifact configurationId) {
                    if (configurationId.equals(configuration.getId())) {
                        return configuration;
                    }
                    return configurationSource.getConfiguration(configurationId);
                }
            };
            this.getLoadParentsInternal(childConfiguration, parents, childSource);
            parents.remove(configuration);
        }
    }

    protected LinkedHashSet<Configuration> getStartParents(Configuration configuration) throws NoSuchConfigException {
        LinkedHashSet<Configuration> startParent = new LinkedHashSet<Configuration>();
        this.getStartParentsInternal(configuration, startParent, this);
        return startParent;
    }

    private void getStartParentsInternal(final Configuration configuration, LinkedHashSet<Configuration> parents, final ConfigurationSource configurationSource) throws NoSuchConfigException {
        DependencyNodeUtil.addServiceParents(configuration.getDependencyNode(), parents, configurationSource);
        for (Configuration childConfiguration : configuration.getChildren()) {
            ConfigurationSource childSource = new ConfigurationSource(){

                @Override
                public Configuration getConfiguration(Artifact configurationId) {
                    if (configurationId.equals(configuration.getId())) {
                        return configuration;
                    }
                    return configurationSource.getConfiguration(configurationId);
                }
            };
            this.getStartParentsInternal(childConfiguration, parents, childSource);
            parents.remove(configuration);
        }
    }

    private static LinkedHashSet<Artifact> getConfigurationIds(Collection<Configuration> configurations) {
        LinkedHashSet<Artifact> configurationIds = new LinkedHashSet<Artifact>(configurations.size());
        for (Configuration configuration : configurations) {
            configurationIds.add(configuration.getId());
        }
        return configurationIds;
    }

    private synchronized void loadDepthFirst(ConfigurationData configurationData, LinkedHashMap<Artifact, UnloadedConfiguration> configurationsToLoad, LifecycleMonitor monitor) throws NoSuchConfigException, IOException, InvalidConfigException, MissingDependencyException {
        Artifact configurationId = configurationData.getId();
        if (!configurationsToLoad.containsKey(configurationId)) {
            monitor.resolving(configurationId);
            LinkedHashSet<Artifact> resolvedParentIds = this.resolveParentIds(configurationData);
            monitor.succeeded(configurationId);
            for (Artifact parentId : resolvedParentIds) {
                if (this.isLoaded(parentId) || !this.isConfiguration(parentId)) continue;
                ConfigurationData parentConfigurationData = this.loadConfigurationData(parentId, monitor);
                this.loadDepthFirst(parentConfigurationData, configurationsToLoad, monitor);
            }
            configurationsToLoad.put(configurationId, new UnloadedConfiguration(configurationData, resolvedParentIds));
        }
    }

    @Override
    public LinkedHashSet<Artifact> sort(List<Artifact> ids, LifecycleMonitor monitor) throws InvalidConfigException, IOException, NoSuchConfigException, MissingDependencyException {
        LinkedHashSet<Artifact> sorted = new LinkedHashSet<Artifact>();
        this.sort(ids, sorted, monitor);
        sorted.retainAll(ids);
        ids.removeAll(sorted);
        return sorted;
    }

    private void sort(Collection<Artifact> ids, LinkedHashSet<Artifact> sorted, LifecycleMonitor monitor) throws InvalidConfigException, IOException, NoSuchConfigException, MissingDependencyException {
        for (Artifact id : ids) {
            if (sorted.contains(id)) continue;
            try {
                ConfigurationData data = this.loadConfigurationData(id, monitor);
                LinkedHashSet<Artifact> parents = this.resolveParentIds(data);
                this.sort(parents, sorted, monitor);
                sorted.add(id);
            }
            catch (NoSuchConfigException e) {
            }
            catch (IOException e) {
            }
            catch (InvalidConfigException e) {
            }
            catch (MissingDependencyException e) {}
        }
    }

    private ConfigurationData loadConfigurationData(Artifact configurationId, LifecycleMonitor monitor) throws NoSuchConfigException, IOException, InvalidConfigException {
        List<ConfigurationStore> storeSnapshot = this.getStoreList();
        monitor.addConfiguration(configurationId);
        monitor.reading(configurationId);
        for (ConfigurationStore store : storeSnapshot) {
            if (!store.containsConfiguration(configurationId)) continue;
            ConfigurationData configurationData = store.loadConfiguration(configurationId);
            monitor.succeeded(configurationId);
            return configurationData;
        }
        NoSuchConfigException exception = new NoSuchConfigException(configurationId);
        monitor.failed(configurationId, exception);
        throw exception;
    }

    private String locateBundle(Artifact configurationId, LifecycleMonitor monitor) throws NoSuchConfigException, IOException, InvalidConfigException {
        if (System.getProperty("geronimo.build.car") == null) {
            return "mvn:" + configurationId.getGroupId() + "/" + configurationId.getArtifactId() + "/" + configurationId.getVersion() + "/" + configurationId.getType();
        }
        monitor.addConfiguration(configurationId);
        monitor.reading(configurationId);
        for (Repository repository : this.repositories) {
            if (!repository.contains(configurationId)) continue;
            return "reference:file://" + repository.getLocation(configurationId).getAbsolutePath();
        }
        NoSuchConfigException exception = new NoSuchConfigException(configurationId);
        monitor.failed(configurationId, exception);
        throw exception;
    }

    @Override
    public LinkedHashSet<Artifact> resolveParentIds(ConfigurationData configurationData) throws MissingDependencyException, InvalidConfigException {
        Environment environment = configurationData.getEnvironment();
        LinkedHashSet<Artifact> parentIds = new LinkedHashSet<Artifact>();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(environment.getDependencies());
        ListIterator<Dependency> iterator = dependencies.listIterator();
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            Artifact resolvedArtifact = this.artifactResolver.resolveInClassLoader(dependency.getArtifact());
            parentIds.add(resolvedArtifact);
            dependency = new Dependency(resolvedArtifact, dependency.getImportType());
            iterator.set(dependency);
        }
        for (ConfigurationData childConfigurationData : configurationData.getChildConfigurations().values()) {
            LinkedHashSet<Artifact> childParentIds = this.resolveParentIds(childConfigurationData);
            childParentIds.remove(configurationData.getId());
            parentIds.addAll(childParentIds);
        }
        return parentIds;
    }

    @Override
    public synchronized LifecycleResults startConfiguration(Artifact id) throws NoSuchConfigException, LifecycleException {
        return this.startConfiguration(id, NullLifecycleMonitor.INSTANCE);
    }

    @Override
    public synchronized LifecycleResults startConfiguration(Artifact id, LifecycleMonitor monitor) throws NoSuchConfigException, LifecycleException {
        if (!id.isResolved()) {
            throw new IllegalArgumentException("Artifact " + id + " is not fully resolved");
        }
        LinkedHashSet<Artifact> unstartedConfigurations = this.configurationModel.start(id);
        SimpleConfigurationManager.addConfigurationsToMonitor(monitor, unstartedConfigurations);
        LifecycleResults results = new LifecycleResults();
        Artifact configurationId = null;
        try {
            for (Artifact unstartedConfiguration : unstartedConfigurations) {
                configurationId = unstartedConfiguration;
                Configuration configuration = this.getConfiguration(configurationId);
                if (configuration == null) {
                    throw new NoSuchConfigException(configurationId, "trying to start ancestor config for config " + id + ", but not found");
                }
                monitor.starting(configurationId);
                this.start(configuration);
                monitor.succeeded(configurationId);
                results.addStarted(configurationId);
            }
        }
        catch (Exception e) {
            monitor.failed(configurationId, e);
            this.configurationModel.stop(id);
            for (Artifact started : results.getStarted()) {
                Configuration configuration = this.getConfiguration(started);
                monitor.stopping(started);
                this.stop(configuration);
                monitor.succeeded(started);
            }
            monitor.finished();
            throw new LifecycleException("start", id, e);
        }
        monitor.finished();
        return results;
    }

    protected void start(Configuration configuration) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized LifecycleResults stopConfiguration(Artifact id) throws NoSuchConfigException {
        return this.stopConfiguration(id, NullLifecycleMonitor.INSTANCE);
    }

    @Override
    public synchronized LifecycleResults stopConfiguration(Artifact id, LifecycleMonitor monitor) throws NoSuchConfigException {
        if (!id.isResolved()) {
            throw new IllegalArgumentException("Artifact " + id + " is not fully resolved");
        }
        LinkedHashSet<Artifact> stopList = this.configurationModel.stop(id);
        SimpleConfigurationManager.addConfigurationsToMonitor(monitor, stopList);
        LifecycleResults results = new LifecycleResults();
        for (Artifact configurationId : stopList) {
            Configuration configuration = this.getConfiguration(configurationId);
            monitor.stopping(configurationId);
            this.stop(configuration);
            monitor.succeeded(configurationId);
            results.addStopped(configurationId);
        }
        monitor.finished();
        return results;
    }

    protected void stop(Configuration configuration) {
    }

    @Override
    public synchronized LifecycleResults restartConfiguration(Artifact id) throws NoSuchConfigException, LifecycleException {
        return this.restartConfiguration(id, NullLifecycleMonitor.INSTANCE);
    }

    @Override
    public synchronized LifecycleResults restartConfiguration(Artifact id, LifecycleMonitor monitor) throws NoSuchConfigException, LifecycleException {
        if (!id.isResolved()) {
            throw new IllegalArgumentException("Artifact " + id + " is not fully resolved");
        }
        LinkedHashSet<Artifact> restartList = this.configurationModel.restart(id);
        SimpleConfigurationManager.addConfigurationsToMonitor(monitor, restartList);
        LifecycleResults results = new LifecycleResults();
        for (Artifact configurationId : restartList) {
            Configuration configuration = this.getConfiguration(configurationId);
            monitor.stopping(configurationId);
            this.stop(configuration);
            monitor.succeeded(configurationId);
            results.addStopped(configurationId);
        }
        restartList = SimpleConfigurationManager.reverse(restartList);
        HashSet<Artifact> skip = new HashSet<Artifact>();
        for (Artifact configurationId : restartList) {
            if (skip.contains(configurationId)) continue;
            try {
                Configuration configuration = this.getConfiguration(configurationId);
                this.applyOverrides(configuration);
                monitor.starting(configurationId);
                this.start(configuration);
                monitor.succeeded(configurationId);
                results.addStarted(configurationId);
            }
            catch (Exception e) {
                results.addFailed(configurationId, e);
                monitor.failed(configurationId, e);
                skip.add(configurationId);
                LinkedHashSet<Artifact> stopList = this.configurationModel.stop(configurationId, false);
                if (!restartList.containsAll(stopList)) {
                    throw new AssertionError((Object)"Configuration data model is corrupt.   You must restart your server.");
                }
                for (Artifact failedId : stopList) {
                    if (results.wasStarted(failedId)) {
                        throw new AssertionError((Object)"Configuration data model is corrupt.   You must restart your server.");
                    }
                    skip.add(failedId);
                }
            }
        }
        monitor.finished();
        if (!results.wasStarted(id)) {
            throw new LifecycleException("restart", id, results);
        }
        return results;
    }

    @Override
    public synchronized LifecycleResults unloadConfiguration(Artifact id) throws NoSuchConfigException, LifecycleException {
        return this.unloadConfiguration(id, NullLifecycleMonitor.INSTANCE);
    }

    @Override
    public synchronized LifecycleResults unloadConfiguration(Artifact id, LifecycleMonitor monitor) throws NoSuchConfigException, LifecycleException {
        if (!id.isResolved()) {
            throw new IllegalArgumentException("Artifact " + id + " is not fully resolved");
        }
        Set<Artifact> started = this.configurationModel.getStarted();
        LinkedHashSet<Artifact> unloadList = this.configurationModel.unload(id);
        SimpleConfigurationManager.addConfigurationsToMonitor(monitor, unloadList);
        LifecycleResults results = new LifecycleResults();
        for (Artifact configurationId : unloadList) {
            Configuration configuration = this.getConfiguration(configurationId);
            if (started.contains(configurationId)) {
                monitor.stopping(configurationId);
                this.stop(configuration);
                monitor.succeeded(configurationId);
                results.addStopped(configurationId);
            } else {
                this.stop(configuration);
            }
            monitor.unloading(configurationId);
            this.unload(configuration);
            monitor.succeeded(configurationId);
            results.addUnloaded(configurationId);
            this.removeConfigurationFromModel(configurationId);
            try {
                Bundle bundle = this.bundles.remove(configurationId);
                if (bundle == null) continue;
                if (BundleUtils.canStop((Bundle)bundle)) {
                    bundle.stop(1);
                }
                if (!BundleUtils.canUninstall((Bundle)bundle)) continue;
                bundle.uninstall();
            }
            catch (BundleException e) {
                monitor.finished();
                throw new LifecycleException("unload", configurationId, e);
            }
        }
        monitor.finished();
        return results;
    }

    protected void removeConfigurationFromModel(Artifact configurationId) throws NoSuchConfigException {
        if (this.configurationModel.containsConfiguration(configurationId)) {
            this.configurationModel.removeConfiguration(configurationId);
        }
        this.configurations.remove(configurationId);
    }

    protected void unload(Configuration configuration) {
        try {
            configuration.doStop();
        }
        catch (Exception e) {
            log.debug("Problem unloading config: " + configuration.getId(), (Throwable)e);
        }
    }

    @Override
    public synchronized LifecycleResults reloadConfiguration(Artifact id) throws NoSuchConfigException, LifecycleException {
        return this.reloadConfiguration(id, (LifecycleMonitor)NullLifecycleMonitor.INSTANCE);
    }

    @Override
    public synchronized LifecycleResults reloadConfiguration(Artifact id, LifecycleMonitor monitor) throws NoSuchConfigException, LifecycleException {
        return this.reloadConfiguration(id, id.getVersion(), monitor);
    }

    @Override
    public synchronized LifecycleResults reloadConfiguration(Artifact id, Version version) throws NoSuchConfigException, LifecycleException {
        return this.reloadConfiguration(id, version, (LifecycleMonitor)NullLifecycleMonitor.INSTANCE);
    }

    @Override
    public synchronized LifecycleResults reloadConfiguration(Artifact id, Version version, LifecycleMonitor monitor) throws NoSuchConfigException, LifecycleException {
        ConfigurationData configurationData;
        if (!id.isResolved()) {
            throw new IllegalArgumentException("Artifact " + id + " is not fully resolved");
        }
        Configuration configuration = this.getConfiguration(id);
        if (configuration == null) {
            ConfigurationData newData;
            ConfigurationData data = null;
            List<ConfigurationStore> storeSnapshot = this.getStoreList();
            for (ConfigurationStore store : storeSnapshot) {
                if (!store.containsConfiguration(id)) continue;
                try {
                    data = store.loadConfiguration(id);
                }
                catch (Exception e) {
                    log.warn("Unable to load existing configuration " + id + " from config store", (Throwable)e);
                }
            }
            if (data == null) {
                throw new NoSuchConfigException(id);
            }
            UnloadedConfiguration existingUnloadedConfiguration = new UnloadedConfiguration(data, new LinkedHashSet<Artifact>());
            Artifact newId = new Artifact(id.getGroupId(), id.getArtifactId(), version, id.getType());
            try {
                newData = this.loadConfigurationData(newId, monitor);
            }
            catch (Exception e) {
                monitor.finished();
                throw new LifecycleException("reload", id, e);
            }
            return this.reloadConfiguration(existingUnloadedConfiguration, newData, monitor);
        }
        ConfigurationData existingConfigurationData = configuration.getConfigurationData();
        UnloadedConfiguration existingUnloadedConfiguration = new UnloadedConfiguration(existingConfigurationData, SimpleConfigurationManager.getResolvedParentIds(configuration));
        Artifact newId = new Artifact(id.getGroupId(), id.getArtifactId(), version, id.getType());
        try {
            configurationData = this.loadConfigurationData(newId, monitor);
        }
        catch (Exception e) {
            monitor.finished();
            throw new LifecycleException("reload", id, e);
        }
        return this.reloadConfiguration(existingUnloadedConfiguration, configurationData, monitor);
    }

    @Override
    public synchronized LifecycleResults reloadConfiguration(ConfigurationData configurationData) throws LifecycleException, NoSuchConfigException {
        return this.reloadConfiguration(configurationData, (LifecycleMonitor)NullLifecycleMonitor.INSTANCE);
    }

    @Override
    public synchronized LifecycleResults reloadConfiguration(ConfigurationData configurationData, LifecycleMonitor monitor) throws LifecycleException, NoSuchConfigException {
        Configuration configuration = this.getConfiguration(configurationData.getId());
        if (configuration == null) {
            throw new NoSuchConfigException(configurationData.getId());
        }
        ConfigurationData existingConfigurationData = configuration.getConfigurationData();
        UnloadedConfiguration existingUnloadedConfiguration = new UnloadedConfiguration(existingConfigurationData, SimpleConfigurationManager.getResolvedParentIds(configuration));
        return this.reloadConfiguration(existingUnloadedConfiguration, configurationData, monitor);
    }

    private boolean hasHardDependency(Artifact configurationId, ConfigurationData configurationData) {
        for (Dependency dependency : configurationData.getEnvironment().getDependencies()) {
            Artifact artifact = dependency.getArtifact();
            if (artifact.getVersion() == null || !artifact.matches(configurationId)) continue;
            return true;
        }
        for (ConfigurationData childConfigurationData : configurationData.getChildConfigurations().values()) {
            if (!this.hasHardDependency(configurationId, childConfigurationData)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LifecycleResults reloadConfiguration(UnloadedConfiguration existingUnloadedConfiguration, ConfigurationData newConfigurationData, LifecycleMonitor monitor) throws LifecycleException, NoSuchConfigException {
        Configuration configuration;
        boolean force = false;
        Artifact existingConfigurationId = existingUnloadedConfiguration.getConfigurationData().getId();
        Artifact newConfigurationId = newConfigurationData.getId();
        LinkedHashMap<Artifact, UnloadedConfiguration> newConfigurations = new LinkedHashMap<Artifact, UnloadedConfiguration>();
        try {
            this.loadDepthFirst(newConfigurationData, newConfigurations, monitor);
        }
        catch (Exception e) {
            monitor.finished();
            throw new LifecycleException("reload", newConfigurationId, e);
        }
        Set<Artifact> started = this.configurationModel.getStarted();
        LinkedHashMap<Artifact, LinkedHashSet<Artifact>> existingParents = new LinkedHashMap<Artifact, LinkedHashSet<Artifact>>();
        LinkedHashMap<Artifact, UnloadedConfiguration> reloadChildren = new LinkedHashMap<Artifact, UnloadedConfiguration>();
        for (Artifact configurationId : SimpleConfigurationManager.reverse(this.configurationModel.reload(existingConfigurationId))) {
            LinkedHashSet<Artifact> resolvedParentIds;
            if (configurationId.equals(existingConfigurationId)) continue;
            if (newConfigurations.containsKey(configurationId)) {
                throw new LifecycleException("reload", newConfigurationId, new IllegalStateException("Circular depenency between " + newConfigurationId + " and " + configurationId));
            }
            Configuration configuration2 = this.getConfiguration(configurationId);
            ConfigurationData configurationData = configuration2.getConfigurationData();
            LinkedHashSet<Artifact> existingParentIds = SimpleConfigurationManager.getResolvedParentIds(configuration2);
            existingParents.put(configurationId, existingParentIds);
            if (this.hasHardDependency(existingConfigurationId, configurationData)) {
                if (force) {
                    throw new LifecycleException("reload", newConfigurationId, new IllegalStateException("Existing configuration " + configurationId + " has a hard dependency on the current version of this configuration " + existingConfigurationId));
                }
                resolvedParentIds = null;
            } else {
                resolvedParentIds = new LinkedHashSet<Artifact>(existingParentIds);
                resolvedParentIds.remove(existingConfigurationId);
                resolvedParentIds.add(newConfigurationId);
            }
            reloadChildren.put(configurationId, new UnloadedConfiguration(configurationData, resolvedParentIds));
            monitor.addConfiguration(configurationId);
        }
        LifecycleResults results = new LifecycleResults();
        for (Artifact configurationId : SimpleConfigurationManager.reverse(reloadChildren).keySet()) {
            Configuration configuration3 = this.getConfiguration(configurationId);
            if (started.contains(configurationId)) {
                monitor.stopping(configurationId);
                this.stop(configuration3);
                monitor.succeeded(configurationId);
                results.addStopped(configurationId);
            } else {
                this.stop(configuration3);
            }
            monitor.unloading(configurationId);
            this.unload(configuration3);
            monitor.succeeded(configurationId);
            results.addUnloaded(configurationId);
        }
        Configuration existingConfiguration = this.getConfiguration(existingConfigurationId);
        if (started.contains(existingConfigurationId)) {
            monitor.stopping(existingConfigurationId);
            this.stop(existingConfiguration);
            monitor.succeeded(existingConfigurationId);
            results.addStopped(existingConfigurationId);
        } else if (existingConfiguration != null) {
            this.stop(existingConfiguration);
        }
        if (existingConfiguration != null) {
            monitor.unloading(existingConfigurationId);
            this.unload(existingConfiguration);
            monitor.succeeded(existingConfigurationId);
            results.addUnloaded(existingConfigurationId);
        }
        boolean reinstatedExisting = false;
        LinkedHashMap<Artifact, Configuration> loadedParents = new LinkedHashMap<Artifact, Configuration>();
        LinkedHashMap<Artifact, Configuration> startedParents = new LinkedHashMap<Artifact, Configuration>();
        Configuration newConfiguration = null;
        Artifact configurationId = null;
        try {
            for (Map.Entry<Artifact, UnloadedConfiguration> entry : newConfigurations.entrySet()) {
                configurationId = entry.getKey();
                UnloadedConfiguration unloadedConfiguration = entry.getValue();
                monitor.loading(configurationId);
                Configuration configuration4 = this.load(unloadedConfiguration.getConfigurationData(), unloadedConfiguration.getResolvedParentIds(), loadedParents);
                monitor.succeeded(configurationId);
                if (configurationId.equals(newConfigurationId)) {
                    newConfiguration = configuration4;
                    Object object = this.reloadingConfigurationLock;
                    synchronized (object) {
                        this.reloadingConfiguration = configuration4;
                        continue;
                    }
                }
                loadedParents.put(configurationId, configuration4);
            }
            if (newConfiguration == null) {
                AssertionError cause = new AssertionError((Object)"Internal error: configuration was not load");
                results.addFailed(newConfigurationId, (Throwable)((Object)cause));
                throw new LifecycleException("reload", newConfigurationId, results);
            }
            if (started.contains(existingConfigurationId)) {
                LinkedHashSet<Configuration> startList = new LinkedHashSet<Configuration>();
                for (Configuration serviceParent : this.getStartParents(newConfiguration)) {
                    if (!loadedParents.containsKey(serviceParent.getId())) continue;
                    startList.add(serviceParent);
                }
                Iterator<Object> i$ = startList.iterator();
                while (i$.hasNext()) {
                    Configuration startParent = (Configuration)i$.next();
                    monitor.starting(configurationId);
                    this.start(startParent);
                    monitor.succeeded(configurationId);
                    startedParents.put(configurationId, startParent);
                }
                monitor.starting(newConfigurationId);
                this.start(newConfiguration);
                monitor.succeeded(newConfigurationId);
            }
            results.setLoaded(loadedParents.keySet());
            results.addLoaded(newConfigurationId);
            if (started.contains(existingConfigurationId)) {
                results.setStarted(startedParents.keySet());
                results.addStarted(newConfigurationId);
            }
            if (this.configurationModel.containsConfiguration(existingConfigurationId)) {
                this.configurationModel.upgradeConfiguration(existingConfigurationId, newConfigurationId, SimpleConfigurationManager.getConfigurationIds(this.getLoadParents(newConfiguration)), SimpleConfigurationManager.getConfigurationIds(this.getStartParents(newConfiguration)));
            } else {
                this.configurationModel.addConfiguration(newConfigurationId, SimpleConfigurationManager.getConfigurationIds(this.getLoadParents(newConfiguration)), SimpleConfigurationManager.getConfigurationIds(this.getStartParents(newConfiguration)));
                this.load(newConfigurationId);
            }
            this.configurations.remove(existingConfiguration.getId());
            this.configurations.put(newConfigurationId, newConfiguration);
            this.migrateConfiguration(existingConfigurationId, newConfigurationId, newConfiguration, started.contains(existingConfigurationId));
        }
        catch (Exception e) {
            monitor.failed(configurationId, e);
            results.addFailed(configurationId, e);
            for (Object configuration5 : startedParents.values()) {
                this.stop((Configuration)configuration5);
            }
            for (Object configuration5 : loadedParents.values()) {
                this.unload((Configuration)configuration5);
            }
            if (newConfiguration != null) {
                this.stop(newConfiguration);
                this.unload(newConfiguration);
            }
            configuration = null;
            try {
                Object configuration5;
                configuration = this.load(existingUnloadedConfiguration.getConfigurationData(), existingUnloadedConfiguration.getResolvedParentIds(), Collections.<Artifact, Configuration>emptyMap());
                configuration5 = this.reloadingConfigurationLock;
                synchronized (configuration5) {
                    this.reloadingConfiguration = configuration;
                }
                if (started.contains(existingConfigurationId)) {
                    this.start(configuration);
                    results.addStarted(existingConfigurationId);
                }
                results.addLoaded(existingConfigurationId);
                this.configurations.put(existingConfigurationId, configuration);
                reinstatedExisting = true;
            }
            catch (Exception ignored) {
                monitor.failed(existingConfigurationId, e);
                if (configuration != null) {
                    this.unload(configuration);
                }
                for (Artifact childId : results.getUnloaded()) {
                    this.configurationModel.unload(childId);
                    this.removeConfigurationFromModel(childId);
                }
                throw new LifecycleException("reload", newConfigurationId, results);
            }
        }
        finally {
            Object e = this.reloadingConfigurationLock;
            synchronized (e) {
                this.reloadingConfiguration = null;
            }
        }
        HashSet<Artifact> skip = new HashSet<Artifact>();
        for (Map.Entry<Artifact, UnloadedConfiguration> entry : reloadChildren.entrySet()) {
            configurationId = entry.getKey();
            UnloadedConfiguration unloadedConfiguration = entry.getValue();
            if (skip.contains(configurationId)) continue;
            configuration = null;
            try {
                LinkedHashSet resolvedParentIds = !reinstatedExisting ? unloadedConfiguration.getResolvedParentIds() : (LinkedHashSet)existingParents.get(configurationId);
                if (resolvedParentIds != null) {
                    monitor.loading(configurationId);
                    configuration = this.load(unloadedConfiguration.getConfigurationData(), resolvedParentIds, Collections.<Artifact, Configuration>emptyMap());
                    Object i$ = this.reloadingConfigurationLock;
                    synchronized (i$) {
                        this.reloadingConfiguration = configuration;
                    }
                    monitor.succeeded(configurationId);
                    if (started.contains(configurationId)) {
                        monitor.starting(configurationId);
                        this.start(configuration);
                        monitor.succeeded(configurationId);
                        results.addStarted(configurationId);
                    }
                    results.addLoaded(configurationId);
                    this.configurations.put(configurationId, configuration);
                    continue;
                }
                this.removeConfigurationFromModel(configurationId);
            }
            catch (Exception e) {
                results.addFailed(configurationId, e);
                monitor.failed(configurationId, e);
                skip.add(configurationId);
                if (configuration != null) {
                    this.unload(configuration);
                }
                LinkedHashSet<Artifact> unloadList = this.configurationModel.unload(configurationId, false);
                this.configurationModel.removeConfiguration(configurationId);
                if (!reloadChildren.keySet().containsAll(unloadList)) {
                    throw new AssertionError((Object)"Configuration data model is corrupt.   You must restart your server.");
                }
                for (Artifact failedId : unloadList) {
                    if (results.wasLoaded(failedId)) {
                        throw new AssertionError((Object)"Configuration data model is corrupt.   You must restart your server.");
                    }
                    skip.add(failedId);
                }
            }
            finally {
                Object object = this.reloadingConfigurationLock;
                synchronized (object) {
                    this.reloadingConfiguration = null;
                }
            }
        }
        if (!results.wasLoaded(existingConfigurationId) && !results.wasFailed(existingConfigurationId)) {
            try {
                this.uninstallConfiguration(existingConfigurationId);
            }
            catch (IOException e) {
                log.error("Unable to uninstall configuration " + existingConfigurationId, (Throwable)e);
            }
        }
        monitor.finished();
        if (results.wasFailed(newConfigurationId) || !results.wasLoaded(newConfigurationId)) {
            throw new LifecycleException("restart", newConfigurationId, results);
        }
        return results;
    }

    protected void migrateConfiguration(Artifact oldName, Artifact newName, Configuration configuration, boolean running) throws NoSuchConfigException {
    }

    private static LinkedHashSet<Artifact> getResolvedParentIds(Configuration configuration) {
        return configuration.getDependencyNode().getParents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstallConfiguration(Artifact configurationId) throws IOException, NoSuchConfigException, LifecycleException {
        SimpleConfigurationManager simpleConfigurationManager = this;
        synchronized (simpleConfigurationManager) {
            if (!configurationId.isResolved()) {
                throw new IllegalArgumentException("Artifact " + configurationId + " is not fully resolved");
            }
            if (this.configurations.containsKey(configurationId)) {
                if (this.isRunning(configurationId)) {
                    this.stopConfiguration(configurationId);
                }
                if (this.isLoaded(configurationId)) {
                    this.unloadConfiguration(configurationId);
                }
            }
            this.uninstall(configurationId);
            for (ConfigurationStore store : this.getStoreList()) {
                if (!store.containsConfiguration(configurationId)) continue;
                store.uninstall(configurationId);
            }
            this.removeConfigurationFromModel(configurationId);
        }
        this.notifyWatchers(configurationId);
    }

    protected void uninstall(Artifact configurationId) {
    }

    private void notifyWatchers(Artifact id) {
        for (DeploymentWatcher watcher : this.watchers) {
            watcher.undeployed(id);
        }
    }

    @Override
    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    @Override
    public boolean isOnline() {
        return false;
    }

    @Override
    public void setOnline(boolean online) {
    }

    protected List<ConfigurationStore> getStoreList() {
        return new ArrayList<ConfigurationStore>(this.stores);
    }

    private static void addConfigurationsToMonitor(LifecycleMonitor monitor, LinkedHashSet<Artifact> configurations) {
        for (Artifact configurationId : configurations) {
            monitor.addConfiguration(configurationId);
        }
    }

    private static LinkedHashSet<Artifact> reverse(LinkedHashSet<Artifact> set) {
        ArrayList<Artifact> reverseList = new ArrayList<Artifact>(set);
        Collections.reverse(reverseList);
        set = new LinkedHashSet<Artifact>(reverseList);
        return set;
    }

    private static LinkedHashMap<Artifact, UnloadedConfiguration> reverse(LinkedHashMap<Artifact, UnloadedConfiguration> map) {
        ArrayList<Map.Entry<Artifact, UnloadedConfiguration>> reverseEntrySet = new ArrayList<Map.Entry<Artifact, UnloadedConfiguration>>(map.entrySet());
        Collections.reverse(reverseEntrySet);
        map = new LinkedHashMap(reverseEntrySet.size());
        for (Map.Entry<Artifact, UnloadedConfiguration> entry : reverseEntrySet) {
            Artifact key = entry.getKey();
            UnloadedConfiguration value = entry.getValue();
            map.put(key, value);
        }
        return map;
    }

    private void applyOverrides(Configuration configuration) throws InvalidConfigException {
        Bundle bundle = configuration.getBundle();
        List<GBeanData> gbeans = configuration.getConfigurationData().getGBeans(bundle);
        if (configuration.getManageableAttributeStore() != null) {
            configuration.getManageableAttributeStore().applyOverrides(configuration.getId(), gbeans, bundle);
        }
    }

    private static class UnloadedConfiguration {
        private final ConfigurationData configurationData;
        private final LinkedHashSet<Artifact> resolvedParentIds;

        public UnloadedConfiguration(ConfigurationData configurationData, LinkedHashSet<Artifact> resolvedParentIds) {
            this.configurationData = configurationData;
            this.resolvedParentIds = resolvedParentIds;
        }

        public ConfigurationData getConfigurationData() {
            return this.configurationData;
        }

        public LinkedHashSet<Artifact> getResolvedParentIds() {
            return this.resolvedParentIds;
        }
    }
}

