/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.rmi;

import java.net.InetSocketAddress;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.rmi.GeronimoRMIServerSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMIRegistryService
implements GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(RMIRegistryService.class);
    private int port = 1099;
    private String host = "0.0.0.0";
    private String classLoaderSpi;
    private Registry registry;
    public static final GBeanInfo GBEAN_INFO;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getProtocol() {
        return "rmi";
    }

    public String getClassLoaderSpi() {
        return this.classLoaderSpi;
    }

    public void setClassLoaderSpi(String classLoaderSpi) {
        this.classLoaderSpi = classLoaderSpi;
    }

    @Override
    public void doStart() throws Exception {
        if (this.classLoaderSpi != null) {
            System.setProperty("java.rmi.server.RMIClassLoaderSpi", this.classLoaderSpi);
        }
        if (System.getProperty("java.rmi.server.hostname") == null && this.host != null && !this.host.equals("0.0.0.0")) {
            System.setProperty("java.rmi.server.hostname", this.host);
        }
        RMISocketFactory socketFactory = RMISocketFactory.getDefaultSocketFactory();
        GeronimoRMIServerSocketFactory serverSocketFactory = new GeronimoRMIServerSocketFactory(this.host);
        this.registry = LocateRegistry.createRegistry(this.port, socketFactory, serverSocketFactory);
        log.debug("Started RMI Registry on port: {}", (Object)this.port);
    }

    @Override
    public void doStop() throws Exception {
        UnicastRemoteObject.unexportObject(this.registry, true);
        log.debug("Stopped RMI Registry");
    }

    @Override
    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception e) {
            log.warn("RMI Registry failed");
        }
    }

    public InetSocketAddress getListenAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic("RMI Naming", RMIRegistryService.class);
        infoFactory.addAttribute("host", String.class, true, true);
        infoFactory.addAttribute("protocol", String.class, false);
        infoFactory.addAttribute("port", Integer.TYPE, true, true);
        infoFactory.addAttribute("classLoaderSpi", String.class, true);
        infoFactory.addAttribute("listenAddress", InetSocketAddress.class, false);
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

