/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationSource;
import org.apache.geronimo.kernel.config.DependencyNode;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.kernel.repository.MissingDependencyException;

public class DependencyNodeUtil {
    public static List<Configuration> getAllServiceParents(DependencyNode root, ConfigurationManager configurationManager) throws NoSuchConfigException {
        ArrayList<Configuration> ancestors = new ArrayList<Configuration>();
        HashSet<Artifact> ids = new HashSet<Artifact>();
        DependencyNodeUtil.addDepthFirstServiceParents(root, ancestors, ids, configurationManager);
        return ancestors;
    }

    private static void addDepthFirstServiceParents(DependencyNode root, List<Configuration> ancestors, Set<Artifact> ids, ConfigurationSource configurationManager) throws NoSuchConfigException {
        Artifact id = root.getId();
        if (!ids.contains(id)) {
            Configuration configuration = DependencyNodeUtil.getConfiguration(id, configurationManager, ids);
            ancestors.add(configuration);
            ids.add(root.getId());
            for (Artifact parentId : root.getServiceParents()) {
                DependencyNode parent = DependencyNodeUtil.getConfiguration(parentId, configurationManager, ids).getDependencyNode();
                DependencyNodeUtil.addDepthFirstServiceParents(parent, ancestors, ids, configurationManager);
            }
        }
    }

    private static Configuration getConfiguration(Artifact id, ConfigurationSource configurationManager, Object info) throws NoSuchConfigException {
        Configuration configuration = configurationManager.getConfiguration(id);
        if (configuration == null) {
            throw new NoSuchConfigException(id, "Configuration " + id + " not found in configuration manager " + configurationManager + " after finding: " + info);
        }
        return configuration;
    }

    public static void addClassParents(DependencyNode node, LinkedHashSet<Configuration> parents, ConfigurationSource configurationManager) throws NoSuchConfigException {
        for (Artifact artifact : node.getClassParents()) {
            parents.add(DependencyNodeUtil.getConfiguration(artifact, configurationManager, parents));
        }
    }

    public static void addServiceParents(DependencyNode node, LinkedHashSet<Configuration> parents, ConfigurationSource configurationManager) throws NoSuchConfigException {
        for (Artifact artifact : node.getServiceParents()) {
            parents.add(DependencyNodeUtil.getConfiguration(artifact, configurationManager, parents));
        }
    }

    public static DependencyNode toDependencyNode(Environment environment, ArtifactResolver artifactResolver, ConfigurationManager configurationFilter) throws MissingDependencyException {
        Artifact id = environment.getConfigId();
        LinkedHashSet<Artifact> classParents = new LinkedHashSet<Artifact>();
        LinkedHashSet<Artifact> serviceParents = new LinkedHashSet<Artifact>();
        for (Dependency dependency : environment.getDependencies()) {
            try {
                Artifact parent = artifactResolver.resolveInClassLoader(dependency.getArtifact());
                if (configurationFilter.isConfiguration(parent)) {
                    if (dependency.getImportType() == ImportType.ALL || dependency.getImportType() == ImportType.SERVICES) {
                        serviceParents.add(parent);
                    }
                    if (dependency.getImportType() != ImportType.ALL && dependency.getImportType() != ImportType.CLASSES) continue;
                    classParents.add(parent);
                    continue;
                }
                if (dependency.getImportType() != ImportType.SERVICES) continue;
                throw new MissingDependencyException("Not a configuration but import type services only", parent, id);
            }
            catch (MissingDependencyException e) {
                throw (MissingDependencyException)new MissingDependencyException("Attempting to resolve environment: " + environment, dependency.getArtifact(), id).initCause(e);
            }
        }
        return new DependencyNode(id, classParents, serviceParents);
    }
}

