/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.rmi;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;

public class GeronimoRMIClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    private static final long serialVersionUID = 8238444722121747980L;
    private int connectionTimeout = -1;
    private int readTimeout = -1;

    public GeronimoRMIClientSocketFactory(int connectionTimeout, int readTimeout) {
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = new Socket();
        socket.bind(null);
        socket.connect(new InetSocketAddress(host, port), this.connectionTimeout > 0 ? this.connectionTimeout : 0);
        if (this.readTimeout >= 0) {
            socket.setSoTimeout(this.readTimeout);
        }
        return socket;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.connectionTimeout;
        result = prime * result + this.readTimeout;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeronimoRMIClientSocketFactory other = (GeronimoRMIClientSocketFactory)obj;
        if (this.connectionTimeout != other.connectionTimeout) {
            return false;
        }
        return this.readTimeout == other.readTimeout;
    }
}

