/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.logging.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.geronimo.logging.SystemLog;
import org.apache.geronimo.logging.impl.Log4jService;
import org.apache.geronimo.logging.impl.OSGiLog4jService;
import org.apache.geronimo.main.ServerInfo;
import org.ops4j.pax.logging.service.internal.Activator;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class LoggingServiceActivator
implements BundleActivator {
    private Activator activator = new Activator();
    private Log4jService service;
    private PropertyChangeListener logManagerChangeListener;

    public void start(BundleContext context) throws Exception {
        ConfigurationAdmin configAdmin;
        String config = System.getProperty("org.apache.geronimo.log4jservice.configuration");
        if (config != null && (configAdmin = this.getService(context, ConfigurationAdmin.class)) != null) {
            ServerInfo serverInfo = this.getService(context, ServerInfo.class);
            Configuration configuration = configAdmin.getConfiguration("org.ops4j.pax.logging");
            this.service = new OSGiLog4jService(config, 60, serverInfo, configuration);
            this.service.start();
            context.registerService(SystemLog.class.getName(), (Object)this.service, null);
        }
        this.activator.start(context);
        if (!Boolean.valueOf(context.getProperty("org.ops4j.pax.logging.skipJUL")).booleanValue()) {
            final LogManager manager = LogManager.getLogManager();
            final Handler[] paxHandlers = manager.getLogger("").getHandlers();
            this.logManagerChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Logger rootLogger = manager.getLogger("");
                    Handler[] handlers = rootLogger.getHandlers();
                    List<Object> handlerList = handlers == null ? Collections.emptyList() : Arrays.asList(handlers);
                    for (Handler h : paxHandlers) {
                        if (handlerList.contains(h)) continue;
                        rootLogger.addHandler(h);
                    }
                    rootLogger.warning("java.util.logging has been reset by application or component");
                }
            };
            manager.addPropertyChangeListener(this.logManagerChangeListener);
        }
    }

    private <T> T getService(BundleContext context, Class<T> name) {
        ServiceReference ref = context.getServiceReference(name.getName());
        return (T)(ref == null ? null : context.getService(ref));
    }

    public void stop(BundleContext context) throws Exception {
        if (this.service != null) {
            this.service.stop();
        }
        this.activator.stop(context);
        if (this.logManagerChangeListener != null) {
            LogManager.getLogManager().removePropertyChangeListener(this.logManagerChangeListener);
        }
    }
}

