/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.auth.x500.X500Principal;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.security.jaas.JaasLoginModuleUse;
import org.apache.geronimo.security.jaas.WrappingLoginModule;
import org.apache.geronimo.security.realm.providers.CertificateCallback;
import org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal;
import org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificatePropertiesFileLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(CertificatePropertiesFileLoginModule.class);
    public static final String USERS_URI = "usersURI";
    public static final String GROUPS_URI = "groupsURI";
    public static final List<String> supportedOptions = Collections.unmodifiableList(Arrays.asList("usersURI", "groupsURI"));
    private final Map users = new HashMap();
    final Map groups = new HashMap();
    private Subject subject;
    private CallbackHandler handler;
    private X500Principal principal;
    private boolean loginSucceeded;
    private final Set<Principal> allPrincipals = new HashSet<Principal>();

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = callbackHandler;
        for (Object option : options.keySet()) {
            if (supportedOptions.contains(option) || JaasLoginModuleUse.supportedOptions.contains(option) || WrappingLoginModule.supportedOptions.contains(option)) continue;
            log.warn("Ignoring option: " + option + ". Not supported.");
        }
        try {
            ServerInfo serverInfo = (ServerInfo)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.SERVERINFO");
            URI usersURI = new URI((String)options.get(USERS_URI));
            URI groupsURI = new URI((String)options.get(GROUPS_URI));
            this.loadProperties(serverInfo, usersURI, groupsURI);
        }
        catch (Exception e) {
            log.error("Failed to load properties", (Throwable)e);
            throw new IllegalArgumentException("Unable to configure properties file login module: " + e.getMessage(), e);
        }
    }

    public void loadProperties(ServerInfo serverInfo, URI usersURI, URI groupURI) throws GeronimoSecurityException {
        try {
            URI userFile = serverInfo.resolve(usersURI);
            URI groupFile = serverInfo.resolve(groupURI);
            InputStream stream = userFile.toURL().openStream();
            Properties tmpUsers = new Properties();
            tmpUsers.load(stream);
            stream.close();
            for (Map.Entry<Object, Object> entry : tmpUsers.entrySet()) {
                this.users.put(entry.getValue(), entry.getKey());
            }
            Properties temp = new Properties();
            stream = groupFile.toURL().openStream();
            temp.load(stream);
            stream.close();
            Enumeration<Object> e = temp.keys();
            while (e.hasMoreElements()) {
                String groupName = (String)e.nextElement();
                String[] userList = ((String)temp.get(groupName)).split(",");
                HashSet<String> userset = (HashSet<String>)this.groups.get(groupName);
                if (userset == null) {
                    userset = new HashSet<String>();
                    this.groups.put(groupName, userset);
                }
                for (int i = 0; i < userList.length; ++i) {
                    String userName = userList[i];
                    userset.add(userName);
                }
            }
        }
        catch (Exception e) {
            log.error("Properties File Login Module - data load failed", (Throwable)e);
            throw new GeronimoSecurityException((Throwable)e);
        }
    }

    public boolean login() throws LoginException {
        this.loginSucceeded = false;
        Callback[] callbacks = new Callback[]{new CertificateCallback()};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        assert (callbacks.length == 1);
        X509Certificate certificate = ((CertificateCallback)callbacks[0]).getCertificate();
        if (certificate == null) {
            throw new FailedLoginException();
        }
        this.principal = certificate.getSubjectX500Principal();
        if (!this.users.containsKey(this.principal.getName())) {
            this.principal = null;
            throw new FailedLoginException();
        }
        this.loginSucceeded = true;
        return true;
    }

    public boolean commit() throws LoginException {
        if (this.loginSucceeded) {
            this.allPrincipals.add(this.principal);
            String userName = (String)this.users.get(this.principal.getName());
            this.allPrincipals.add(new GeronimoUserPrincipal(userName));
            block0: for (String groupName : this.groups.keySet()) {
                Set users = (Set)this.groups.get(groupName);
                for (String user : users) {
                    if (!userName.equals(user)) continue;
                    this.allPrincipals.add(new GeronimoGroupPrincipal(groupName));
                    continue block0;
                }
            }
            this.subject.getPrincipals().addAll(this.allPrincipals);
        }
        this.principal = null;
        return this.loginSucceeded;
    }

    public boolean abort() throws LoginException {
        if (this.loginSucceeded) {
            this.principal = null;
            this.allPrincipals.clear();
        }
        return this.loginSucceeded;
    }

    public boolean logout() throws LoginException {
        this.loginSucceeded = false;
        this.principal = null;
        if (!this.subject.isReadOnly()) {
            this.subject.getPrincipals().removeAll(this.allPrincipals);
        }
        this.allPrincipals.clear();
        return true;
    }
}

