/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class KerberosLoginModule
implements LoginModule {
    private Subject subject;
    private LoginModule krb5LoginModule;
    private Subject krb5Subject;
    private Principal addOnPrincipal;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        String krb5LoginModuleClass = (String)options.get("krb5LoginModuleClass");
        try {
            this.krb5LoginModule = (LoginModule)Class.forName(krb5LoginModuleClass).newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to configure kerberos login module: " + e.getMessage(), e);
        }
        HashMap options1 = new HashMap();
        for (Object key : options.keySet()) {
            String key1 = (String)key;
            if (!key1.startsWith("krb_")) continue;
            options1.put(key1.substring(4), options.get(key1));
        }
        this.krb5Subject = new Subject();
        this.krb5LoginModule.initialize(this.krb5Subject, callbackHandler, sharedState, options1);
        String addOnPrincipalClass = (String)options.get("addOnPrincipalClass");
        String addOnPrincipalName = (String)options.get("addOnPrincipalName");
        if (addOnPrincipalClass != null && !addOnPrincipalClass.equals("")) {
            try {
                this.addOnPrincipal = (Principal)Class.forName(addOnPrincipalClass).getConstructor(String.class).newInstance(addOnPrincipalName);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to configure kerberos login module: " + e.getMessage(), e);
            }
        }
    }

    public boolean login() throws LoginException {
        return this.krb5LoginModule.login();
    }

    public boolean commit() throws LoginException {
        boolean result = this.krb5LoginModule.commit();
        if (result) {
            if (this.addOnPrincipal != null) {
                this.subject.getPrincipals().add(this.addOnPrincipal);
            }
            this.subject.getPrincipals().addAll(this.krb5Subject.getPrincipals());
            this.subject.getPublicCredentials().addAll(this.krb5Subject.getPublicCredentials());
            this.subject.getPrivateCredentials().addAll(this.krb5Subject.getPrivateCredentials());
        }
        return result;
    }

    public boolean abort() throws LoginException {
        return this.krb5LoginModule.abort();
    }

    public boolean logout() throws LoginException {
        if (!this.subject.isReadOnly()) {
            if (this.addOnPrincipal != null) {
                this.subject.getPrincipals().remove(this.addOnPrincipal);
            }
            this.subject.getPrincipals().removeAll(this.krb5Subject.getPrincipals());
            this.subject.getPublicCredentials().removeAll(this.krb5Subject.getPublicCredentials());
            this.subject.getPrivateCredentials().removeAll(this.krb5Subject.getPrivateCredentials());
        }
        return this.krb5LoginModule.logout();
    }
}

