/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security;

import java.security.Policy;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.security.GeronimoSecurityPermission;
import org.apache.geronimo.security.SecurityService;
import org.apache.geronimo.security.jacc.PolicyContextHandlerContainerSubject;
import org.apache.geronimo.security.jacc.PolicyContextHandlerEjbArguments;
import org.apache.geronimo.security.jacc.PolicyContextHandlerEnterpriseBean;
import org.apache.geronimo.security.jacc.PolicyContextHandlerHttpServletRequest;
import org.apache.geronimo.security.jacc.PolicyContextHandlerSOAPMessage;
import org.apache.geronimo.security.util.ConfigurationUtil;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class SecurityServiceImpl
implements SecurityService {
    public static boolean POLICY_INSTALLED = false;
    private static final Logger log = LoggerFactory.getLogger(SecurityServiceImpl.class);
    public static final GeronimoSecurityPermission CONFIGURE = new GeronimoSecurityPermission("configure");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityServiceImpl(@ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader, @ParamReference(name="ServerInfo") ServerInfo serverInfo, @ParamAttribute(name="policyConfigurationFactory") String policyConfigurationFactory, @ParamAttribute(name="policyProvider") String policyProvider, @ParamAttribute(name="keyStore") String keyStore, @ParamAttribute(name="keyStorePassword") String keyStorePassword, @ParamAttribute(name="trustStore") String trustStore, @ParamAttribute(name="trustStorePassword") String trustStorePassword) throws PolicyContextException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        ConfigurationUtil.registerPolicyContextHandler(new PolicyContextHandlerContainerSubject(), true);
        ConfigurationUtil.registerPolicyContextHandler(new PolicyContextHandlerSOAPMessage(), true);
        ConfigurationUtil.registerPolicyContextHandler(new PolicyContextHandlerHttpServletRequest(), true);
        ConfigurationUtil.registerPolicyContextHandler(new PolicyContextHandlerEnterpriseBean(), true);
        ConfigurationUtil.registerPolicyContextHandler(new PolicyContextHandlerEjbArguments(), true);
        if (!POLICY_INSTALLED) {
            if ((policyProvider = this.sysOverRide(policyProvider, "javax.security.jacc.policy.provider")) != null) {
                Policy policy = (Policy)classLoader.loadClass(policyProvider).newInstance();
                policy.refresh();
                Policy.setPolicy(policy);
            }
            POLICY_INSTALLED = true;
        }
        if ((policyConfigurationFactory = this.sysOverRide(policyConfigurationFactory, "javax.security.jacc.PolicyConfigurationFactory.provider")) != null) {
            Thread currentThread = Thread.currentThread();
            ClassLoader oldClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(classLoader);
            try {
                PolicyConfigurationFactory.getPolicyConfigurationFactory();
            }
            finally {
                currentThread.setContextClassLoader(oldClassLoader);
            }
        }
        if (keyStore != null) {
            this.sysOverRide(serverInfo.resolveServerPath(keyStore), "javax.net.ssl.keyStore");
        }
        if (keyStorePassword != null) {
            this.sysOverRide(keyStorePassword, "javax.net.ssl.keyStorePassword");
        }
        if (trustStore != null) {
            this.sysOverRide(serverInfo.resolveServerPath(trustStore), "javax.net.ssl.trustStore");
        }
        if (trustStorePassword != null) {
            this.sysOverRide(trustStorePassword, "javax.net.ssl.trustStorePassword");
        }
        log.debug("javax.net.ssl.keyStore: " + System.getProperty("javax.net.ssl.keyStore"));
        log.debug("javax.net.ssl.trustStore: " + System.getProperty("javax.net.ssl.trustStore"));
        log.debug("JACC factory registered");
    }

    private String sysOverRide(String attribute, String sysVar) {
        String sysValue = System.getProperty(sysVar);
        if (sysValue != null) {
            return sysValue;
        }
        if (attribute != null) {
            System.setProperty(sysVar, attribute);
        }
        return attribute;
    }
}

