/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.deploy;

import java.beans.PropertyEditorManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.geronimo.common.propertyeditor.PropertyEditorException;
import org.apache.geronimo.common.propertyeditor.TextPropertyEditorSupport;

public class MapOfSets
extends HashMap {
    public MapOfSets() {
    }

    public MapOfSets(int size) {
        super(size);
    }

    public MapOfSets(Map map) {
        super(map);
    }

    static {
        PropertyEditorManager.registerEditor(MapOfSets.class, MapOfSetsEditor.class);
    }

    public static class MapOfSetsEditor
    extends TextPropertyEditorSupport {
        public void setAsText(String text) {
            if (text != null) {
                try {
                    ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes());
                    Properties p = new Properties();
                    p.load(is);
                    MapOfSets result = new MapOfSets(p.size());
                    for (Map.Entry<Object, Object> entry : p.entrySet()) {
                        HashSet<String> values = new HashSet<String>(Arrays.asList(((String)entry.getValue()).split(",")));
                        result.put(entry.getKey(), values);
                    }
                    this.setValue(result);
                }
                catch (IOException e) {
                    throw new PropertyEditorException((Throwable)e);
                }
            } else {
                this.setValue(null);
            }
        }

        public String getAsText() {
            Map map = (Map)this.getValue();
            if (map == null) {
                return null;
            }
            StringBuilder text = new StringBuilder();
            for (Map.Entry entry : map.entrySet()) {
                text.append(entry.getKey()).append("=");
                Set values = (Set)entry.getValue();
                Iterator iterator1 = values.iterator();
                while (iterator1.hasNext()) {
                    String value = (String)iterator1.next();
                    text.append(value);
                    if (!iterator1.hasNext()) continue;
                    text.append(",");
                }
            }
            return text.toString();
        }
    }
}

