/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.geronimo.security.realm.providers.ClearableCallbackHandler;

public class PasswordCallbackHandler
implements ClearableCallbackHandler {
    private final String username;
    private final char[] password;

    public PasswordCallbackHandler(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (callback instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback;
                nc.setName(this.username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callback;
                pc.setPassword(this.password);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    @Override
    public void clear() {
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
        }
    }
}

