/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.ca;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URI;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Properties;
import org.apache.geronimo.crypto.CaUtils;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.management.geronimo.CertificateStore;
import org.apache.geronimo.management.geronimo.CertificateStoreException;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCertificateStore
implements CertificateStore,
GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(FileCertificateStore.class);
    private ServerInfo serverInfo;
    private Kernel kernel;
    private AbstractName abstractName;
    private URI directoryPath;
    private static final String SERIAL_NUMBER_FILE = "highest-serial-number.txt";
    private static final String CERT_FILE_SUFFIX = ".txt";
    private static final String CA_CERT_FILE = "ca-cert.txt";
    private static final String CHALLENGE_FILENAME = "challenge.properties";
    private static final String CHALLENGE_FILE_HEADER = "Challenge File";
    private File storeDir = null;
    private File highestSerialFile = null;
    private BigInteger highestSerialNumber = null;
    private Properties challenges = null;
    public static final GBeanInfo GBEAN_INFO;

    public FileCertificateStore(ServerInfo serverInfo, URI directoryPath, Kernel kernel, AbstractName abstractName) {
        this.serverInfo = serverInfo;
        this.kernel = kernel;
        this.abstractName = abstractName;
        this.directoryPath = directoryPath;
    }

    public void storeCertificate(Certificate cert) throws CertificateStoreException {
        BigInteger sNo = ((X509Certificate)cert).getSerialNumber();
        File certFile = new File(this.storeDir, sNo + CERT_FILE_SUFFIX);
        try {
            if (sNo.compareTo(this.getHighestSerialNumber()) == 1) {
                this.setHighestSerialNumber(sNo);
            }
            FileOutputStream fout = new FileOutputStream(certFile);
            CaUtils.storeInBase64((OutputStream)fout, (byte[])cert.getEncoded(), (String)"-----BEGIN CERTIFICATE-----", (String)"-----END CERTIFICATE-----", (int)76);
            fout.close();
        }
        catch (Exception e) {
            throw new CertificateStoreException("Error while storing certificate.", (Throwable)e);
        }
    }

    public Certificate getCertificate(BigInteger sNo) throws CertificateStoreException {
        File certFile = new File(this.storeDir, sNo + CERT_FILE_SUFFIX);
        if (!certFile.exists()) {
            throw new CertificateStoreException("No certificate with serial number " + sNo + " found.");
        }
        try {
            FileInputStream fin = new FileInputStream(certFile);
            CertificateFactory certFac = CertificateFactory.getInstance("X.509");
            Certificate cert = certFac.generateCertificate(fin);
            fin.close();
            return cert;
        }
        catch (Exception e) {
            throw new CertificateStoreException("Error while retrieving certificate.", (Throwable)e);
        }
    }

    public String getCertificateBase64Text(BigInteger sNo) throws CertificateStoreException {
        File certFile = new File(this.storeDir, sNo + CERT_FILE_SUFFIX);
        if (!certFile.exists()) {
            throw new CertificateStoreException("No certificate with serial number " + sNo + " found.");
        }
        try {
            FileInputStream fin = new FileInputStream(certFile);
            byte[] data = new byte[fin.available()];
            fin.read(data);
            fin.close();
            return new String(data);
        }
        catch (Exception e) {
            throw new CertificateStoreException("Error while retrieving certificate.", (Throwable)e);
        }
    }

    public BigInteger getHighestSerialNumber() throws CertificateStoreException {
        if (this.highestSerialNumber == null) {
            try {
                FileInputStream finp = new FileInputStream(this.highestSerialFile);
                byte[] data = new byte[finp.available()];
                finp.read(data);
                finp.close();
                this.highestSerialNumber = new BigInteger(new String(data).trim());
            }
            catch (Exception e) {
                throw new CertificateStoreException("Error while getting serial number.", (Throwable)e);
            }
        }
        return this.highestSerialNumber;
    }

    public BigInteger getNextSerialNumber() throws CertificateStoreException {
        this.setHighestSerialNumber(this.getHighestSerialNumber().add(BigInteger.ONE));
        return this.highestSerialNumber;
    }

    public boolean containsCertificate(BigInteger sNo) {
        File certFile = new File(this.storeDir, sNo + CERT_FILE_SUFFIX);
        return certFile.exists();
    }

    private void setHighestSerialNumber(BigInteger sNo) throws CertificateStoreException {
        try {
            this.highestSerialNumber = sNo;
            FileOutputStream fout = new FileOutputStream(this.highestSerialFile);
            fout.write(this.highestSerialNumber.toString().getBytes());
            fout.close();
        }
        catch (Exception e) {
            throw new CertificateStoreException("Error while setting highest serial number.", (Throwable)e);
        }
    }

    public boolean storeCACertificate(Certificate cert) throws CertificateStoreException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(new File(this.storeDir, CA_CERT_FILE));
            CaUtils.storeInBase64((OutputStream)fout, (byte[])cert.getEncoded(), (String)"-----BEGIN CERTIFICATE-----", (String)"-----END CERTIFICATE-----", (int)76);
            fout.close();
            return true;
        }
        catch (Exception e) {
            throw new CertificateStoreException("Exception in storing CA certificate", (Throwable)e);
        }
    }

    public Certificate getCACertificate() throws CertificateStoreException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(new File(this.storeDir, CA_CERT_FILE));
            CertificateFactory certFac = CertificateFactory.getInstance("X.509");
            Certificate cert = certFac.generateCertificate(fin);
            fin.close();
            return cert;
        }
        catch (Exception e) {
            throw new CertificateStoreException("Exception in getting CA certificate", (Throwable)e);
        }
    }

    public boolean setCertificateChallenge(BigInteger sNo, String challenge) {
        if (this.challenges == null) {
            this.loadChallenges();
        }
        if (!this.challenges.containsKey(sNo.toString())) {
            this.challenges.setProperty(sNo.toString(), challenge);
            this.storeChallenges();
            return true;
        }
        return false;
    }

    private void storeChallenges() {
        if (this.challenges == null) {
            this.loadChallenges();
        }
        File chFile = new File(this.storeDir, CHALLENGE_FILENAME);
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(chFile);
            this.challenges.store(fout, CHALLENGE_FILE_HEADER);
            fout.close();
        }
        catch (Exception e) {
            log.error("Exceptions while storing challenges file. File = " + chFile.getAbsolutePath(), (Throwable)e);
        }
    }

    private void loadChallenges() {
        File chFile = new File(this.storeDir, CHALLENGE_FILENAME);
        FileInputStream fin = null;
        try {
            if (!chFile.exists()) {
                chFile.createNewFile();
            }
            fin = new FileInputStream(chFile);
            this.challenges = new Properties();
            this.challenges.load(fin);
            fin.close();
        }
        catch (IOException e) {
            log.error("Exceptions while loading challenges file. File = " + chFile.getAbsolutePath(), (Throwable)e);
        }
    }

    public void doFail() {
    }

    public void doStart() throws Exception {
        this.serverInfo.resolveServer(this.directoryPath);
        URI dirURI = this.serverInfo != null ? this.serverInfo.resolve(this.directoryPath) : this.directoryPath;
        if (!dirURI.getScheme().equals("file")) {
            throw new IllegalStateException("FileCertificateStore must have a root that's a local directory (not " + dirURI + ")");
        }
        this.storeDir = new File(dirURI);
        if (!this.storeDir.exists()) {
            this.storeDir.mkdirs();
            log.debug("Created directory " + this.storeDir.getAbsolutePath());
        } else if (!this.storeDir.isDirectory() || !this.storeDir.canRead()) {
            throw new IllegalStateException("FileCertificateStore must have a root that's a valid readable directory (not " + this.storeDir.getAbsolutePath() + ")");
        }
        log.debug("CertificateStore directory is " + this.storeDir.getAbsolutePath());
        this.highestSerialFile = new File(this.storeDir, SERIAL_NUMBER_FILE);
        if (!this.highestSerialFile.exists()) {
            try {
                this.setHighestSerialNumber(BigInteger.ZERO);
            }
            catch (CertificateStoreException e) {
                log.error("Error initializing certificate store. storeDir=" + this.storeDir, (Throwable)e);
            }
        }
        this.loadChallenges();
    }

    public void doStop() throws Exception {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(FileCertificateStore.class, (String)"CertificateStore");
        infoFactory.addAttribute("directoryPath", URI.class, true, false);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("abstractName", AbstractName.class, false);
        infoFactory.addReference("ServerInfo", ServerInfo.class);
        infoFactory.addInterface(CertificateStore.class);
        infoFactory.setConstructor(new String[]{"ServerInfo", "directoryPath", "kernel", "abstractName"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

