/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.deploy;

import java.beans.PropertyEditorManager;
import java.io.Serializable;
import org.apache.geronimo.common.propertyeditor.PropertyEditorException;
import org.apache.geronimo.common.propertyeditor.TextPropertyEditorSupport;

public class PrincipalInfo
implements Serializable {
    private final String className;
    private final String principalName;

    public PrincipalInfo(String className, String principalName) {
        this.className = className;
        this.principalName = principalName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    static {
        PropertyEditorManager.registerEditor(PrincipalInfo.class, PrincipalEditor.class);
    }

    public static class PrincipalEditor
    extends TextPropertyEditorSupport {
        public void setAsText(String text) {
            if (text != null) {
                String[] parts = text.split(",");
                if (parts.length != 2) {
                    throw new PropertyEditorException("Principal should have the form 'name,class'");
                }
                PrincipalInfo principalInfo = new PrincipalInfo(parts[0], parts[1]);
                this.setValue(principalInfo);
            } else {
                this.setValue(null);
            }
        }

        public String getAsText() {
            PrincipalInfo principalInfo = (PrincipalInfo)this.getValue();
            if (principalInfo == null) {
                return null;
            }
            return principalInfo.getPrincipalName() + "," + principalInfo.getClassName();
        }
    }
}

