/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal;
import org.apache.geronimo.security.realm.providers.HeaderMismatchException;

public abstract class GenericHttpHeaderLoginmodule {
    private static Log log = LogFactory.getLog(GenericHttpHeaderLoginmodule.class);
    protected Subject subject;
    protected String username;
    protected String headerNames;
    protected String authenticationAuthority;
    protected CallbackHandler callbackHandler;
    protected boolean loginSucceeded;
    protected HttpServletRequest httpRequest;
    protected Set<Principal> allPrincipals = new HashSet<Principal>();
    protected Set<String> groups = new HashSet<String>();

    protected void commitHelper() {
        for (String group : this.groups) {
            this.allPrincipals.add(new GeronimoGroupPrincipal(group));
        }
        this.subject.getPrincipals().addAll(this.allPrincipals);
        this.subject.getPublicCredentials().add(this.username);
    }

    public void abortHelper() {
        this.allPrincipals.clear();
        this.groups.clear();
    }

    public void logoutHelper() {
        this.groups.clear();
        if (!this.subject.isReadOnly()) {
            this.subject.getPrincipals().removeAll(this.allPrincipals);
        }
        this.allPrincipals.clear();
    }

    public Map<String, String> matchHeaders(HttpServletRequest request, String[] headers) throws HeaderMismatchException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (String header : headers) {
            String headerValue = request.getHeader(header);
            if (headerValue != null) {
                headerMap.put(header, headerValue);
                continue;
            }
            log.warn((Object)("An Unauthorized attempt has been made to access the protected resource from host " + request.getRemoteHost()));
        }
        return headerMap;
    }
}

