/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.osgi;

import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelFactory;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.osgi.ConfigurationActivator;
import org.apache.geronimo.kernel.util.Main;
import org.apache.geronimo.system.main.LongStartupMonitor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootActivator
implements BundleActivator {
    private static final Logger log = LoggerFactory.getLogger(BootActivator.class);
    private ServiceRegistration kernelRegistration;
    private BundleActivator configurationActivator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bundleContext) throws Exception {
        if (bundleContext.getServiceReference(Kernel.class.getName()) == null) {
            LongStartupMonitor monitor = new LongStartupMonitor();
            monitor.systemStarting(System.currentTimeMillis());
            Kernel kernel = KernelFactory.newInstance((BundleContext)bundleContext).createKernel("geronimo");
            kernel.boot();
            monitor.systemStarted(kernel);
            Dictionary dictionary = null;
            this.kernelRegistration = bundleContext.registerService(Kernel.class.getName(), (Object)kernel, dictionary);
            Bundle bundle = bundleContext.getBundle();
            URL plan = bundle.getEntry("META-INF/config.ser");
            InputStream in = plan.openStream();
            try {
                ConfigurationData data = ConfigurationUtil.readConfigurationData((InputStream)in);
                data.setBundleContext(bundleContext);
                AbstractName name = ConfigurationUtil.loadBootstrapConfiguration((Kernel)kernel, (ConfigurationData)data, (BundleContext)bundleContext, (boolean)false);
            }
            finally {
                in.close();
            }
            if (bundleContext.getServiceReference(org.apache.geronimo.main.Main.class.getName()) == null) {
                this.registerMainService(bundleContext, kernel);
            }
        } else {
            this.configurationActivator = new ConfigurationActivator();
            this.configurationActivator.start(bundleContext);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.configurationActivator == null) {
            Kernel kernel = (Kernel)bundleContext.getService(this.kernelRegistration.getReference());
            kernel.shutdown();
            this.kernelRegistration.unregister();
            this.kernelRegistration = null;
        } else {
            this.configurationActivator.stop(bundleContext);
        }
    }

    private void registerMainService(BundleContext bundleContext, Kernel kernel) {
        try {
            final Main main = (Main)kernel.getGBean(Main.class);
            bundleContext.registerService(org.apache.geronimo.main.Main.class.getName(), (Object)new org.apache.geronimo.main.Main(){

                public int execute(Object opaque) {
                    return main.execute(opaque);
                }
            }, null);
        }
        catch (GBeanNotFoundException gBeanNotFoundException) {
            // empty catch block
        }
    }
}

